package io.github.cdklabs.projen.circleci;

/**
 * (experimental) Used for invoking all command-line programs, taking either a map of configuration values, or, when called in its short-form, a string that will be used as both the command and name.
 * <p>
 * Run commands are executed using non-login shells by default,
 * so you must explicitly source any dotfiles as part of the command.
 * <p>
 * Not used because type incompatible types in steps array
 * <p>
 * @see <a href="https://circleci.com/docs/2.0/configuration-reference/#run">https://circleci.com/docs/2.0/configuration-reference/#run</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-28T17:20:29.217Z")
@software.amazon.jsii.Jsii(module = io.github.cdklabs.projen.$Module.class, fqn = "projen.circleci.Run")
@software.amazon.jsii.Jsii.Proxy(Run.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface Run extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Command to run via the shell.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getCommand();

    /**
     * (experimental) Whether this step should run in the background (default: false).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getBackground() {
        return null;
    }

    /**
     * (experimental) Additional environmental variables, locally scoped to command.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getEnvironment() {
        return null;
    }

    /**
     * (experimental) Title of the step to be shown in the CircleCI UI (default: full command).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * (experimental) Elapsed time the command can run without output such as “20m”, “1.25h”, “5s”. The default is 10 minutes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getNoOutputTimeout() {
        return null;
    }

    /**
     * (experimental) Shell to use for execution command.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getShell() {
        return null;
    }

    /**
     * (experimental) Specify when to enable or disable the step.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getWhen() {
        return null;
    }

    /**
     * (experimental) In which directory to run this step.
     * <p>
     * Will be interpreted relative to the working_directory of the job). (default: .)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getWorkingDirectory() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link Run}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link Run}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<Run> {
        java.lang.String command;
        java.lang.String background;
        java.lang.String environment;
        java.lang.String name;
        java.lang.String noOutputTimeout;
        java.lang.String shell;
        java.lang.String when;
        java.lang.String workingDirectory;

        /**
         * Sets the value of {@link Run#getCommand}
         * @param command Command to run via the shell. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder command(java.lang.String command) {
            this.command = command;
            return this;
        }

        /**
         * Sets the value of {@link Run#getBackground}
         * @param background Whether this step should run in the background (default: false).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder background(java.lang.String background) {
            this.background = background;
            return this;
        }

        /**
         * Sets the value of {@link Run#getEnvironment}
         * @param environment Additional environmental variables, locally scoped to command.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder environment(java.lang.String environment) {
            this.environment = environment;
            return this;
        }

        /**
         * Sets the value of {@link Run#getName}
         * @param name Title of the step to be shown in the CircleCI UI (default: full command).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link Run#getNoOutputTimeout}
         * @param noOutputTimeout Elapsed time the command can run without output such as “20m”, “1.25h”, “5s”. The default is 10 minutes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder noOutputTimeout(java.lang.String noOutputTimeout) {
            this.noOutputTimeout = noOutputTimeout;
            return this;
        }

        /**
         * Sets the value of {@link Run#getShell}
         * @param shell Shell to use for execution command.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder shell(java.lang.String shell) {
            this.shell = shell;
            return this;
        }

        /**
         * Sets the value of {@link Run#getWhen}
         * @param when Specify when to enable or disable the step.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder when(java.lang.String when) {
            this.when = when;
            return this;
        }

        /**
         * Sets the value of {@link Run#getWorkingDirectory}
         * @param workingDirectory In which directory to run this step.
         *                         Will be interpreted relative to the working_directory of the job). (default: .)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder workingDirectory(java.lang.String workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link Run}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public Run build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link Run}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Run {
        private final java.lang.String command;
        private final java.lang.String background;
        private final java.lang.String environment;
        private final java.lang.String name;
        private final java.lang.String noOutputTimeout;
        private final java.lang.String shell;
        private final java.lang.String when;
        private final java.lang.String workingDirectory;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.command = software.amazon.jsii.Kernel.get(this, "command", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.background = software.amazon.jsii.Kernel.get(this, "background", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.environment = software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.noOutputTimeout = software.amazon.jsii.Kernel.get(this, "noOutputTimeout", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.shell = software.amazon.jsii.Kernel.get(this, "shell", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.when = software.amazon.jsii.Kernel.get(this, "when", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.workingDirectory = software.amazon.jsii.Kernel.get(this, "workingDirectory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.command = java.util.Objects.requireNonNull(builder.command, "command is required");
            this.background = builder.background;
            this.environment = builder.environment;
            this.name = builder.name;
            this.noOutputTimeout = builder.noOutputTimeout;
            this.shell = builder.shell;
            this.when = builder.when;
            this.workingDirectory = builder.workingDirectory;
        }

        @Override
        public final java.lang.String getCommand() {
            return this.command;
        }

        @Override
        public final java.lang.String getBackground() {
            return this.background;
        }

        @Override
        public final java.lang.String getEnvironment() {
            return this.environment;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getNoOutputTimeout() {
            return this.noOutputTimeout;
        }

        @Override
        public final java.lang.String getShell() {
            return this.shell;
        }

        @Override
        public final java.lang.String getWhen() {
            return this.when;
        }

        @Override
        public final java.lang.String getWorkingDirectory() {
            return this.workingDirectory;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("command", om.valueToTree(this.getCommand()));
            if (this.getBackground() != null) {
                data.set("background", om.valueToTree(this.getBackground()));
            }
            if (this.getEnvironment() != null) {
                data.set("environment", om.valueToTree(this.getEnvironment()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getNoOutputTimeout() != null) {
                data.set("noOutputTimeout", om.valueToTree(this.getNoOutputTimeout()));
            }
            if (this.getShell() != null) {
                data.set("shell", om.valueToTree(this.getShell()));
            }
            if (this.getWhen() != null) {
                data.set("when", om.valueToTree(this.getWhen()));
            }
            if (this.getWorkingDirectory() != null) {
                data.set("workingDirectory", om.valueToTree(this.getWorkingDirectory()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("projen.circleci.Run"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            Run.Jsii$Proxy that = (Run.Jsii$Proxy) o;

            if (!command.equals(that.command)) return false;
            if (this.background != null ? !this.background.equals(that.background) : that.background != null) return false;
            if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.noOutputTimeout != null ? !this.noOutputTimeout.equals(that.noOutputTimeout) : that.noOutputTimeout != null) return false;
            if (this.shell != null ? !this.shell.equals(that.shell) : that.shell != null) return false;
            if (this.when != null ? !this.when.equals(that.when) : that.when != null) return false;
            return this.workingDirectory != null ? this.workingDirectory.equals(that.workingDirectory) : that.workingDirectory == null;
        }

        @Override
        public final int hashCode() {
            int result = this.command.hashCode();
            result = 31 * result + (this.background != null ? this.background.hashCode() : 0);
            result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.noOutputTimeout != null ? this.noOutputTimeout.hashCode() : 0);
            result = 31 * result + (this.shell != null ? this.shell.hashCode() : 0);
            result = 31 * result + (this.when != null ? this.when.hashCode() : 0);
            result = 31 * result + (this.workingDirectory != null ? this.workingDirectory.hashCode() : 0);
            return result;
        }
    }
}
