package io.github.cdklabs.projen.github;

/**
 * (experimental) Sets up mergify to merging approved pull requests.
 * <p>
 * If <code>buildJob</code> is specified, the specified GitHub workflow job ID is required
 * to succeed in order for the PR to be merged.
 * <p>
 * <code>approvedReviews</code> specified the number of code review approvals required for
 * the PR to be merged.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-28T17:20:29.219Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = io.github.cdklabs.projen.$Module.class, fqn = "projen.github.AutoMerge")
public class AutoMerge extends io.github.cdklabs.projen.Component {

    protected AutoMerge(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AutoMerge(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param github This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public AutoMerge(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.github.GitHub github, final @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.github.AutoMergeOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(github, "github is required"), options });
    }

    /**
     * @param github This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public AutoMerge(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.github.GitHub github) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(github, "github is required") });
    }

    /**
     * (experimental) Adds conditions to the auto merge rule.
     * <p>
     * @param conditions The conditions to add (mergify syntax). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addConditions(final @org.jetbrains.annotations.NotNull java.lang.String... conditions) {
        software.amazon.jsii.Kernel.call(this, "addConditions", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(conditions).toArray(Object[]::new));
    }

    /**
     * (experimental) Adds conditions that will be rendered only during synthesis.
     * <p>
     * @param later The later. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addConditionsLater(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.github.IAddConditionsLater later) {
        software.amazon.jsii.Kernel.call(this, "addConditionsLater", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(later, "later is required") });
    }

    /**
     * (experimental) A fluent builder for {@link io.github.cdklabs.projen.github.AutoMerge}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<io.github.cdklabs.projen.github.AutoMerge> {
        /**
         * @return a new instance of {@link Builder}.
         * @param github This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final io.github.cdklabs.projen.github.GitHub github) {
            return new Builder(github);
        }

        private final io.github.cdklabs.projen.github.GitHub github;
        private io.github.cdklabs.projen.github.AutoMergeOptions.Builder options;

        private Builder(final io.github.cdklabs.projen.github.GitHub github) {
            this.github = github;
        }

        /**
         * (experimental) Number of approved code reviews.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @param approvedReviews Number of approved code reviews. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder approvedReviews(final java.lang.Number approvedReviews) {
            this.options().approvedReviews(approvedReviews);
            return this;
        }

        /**
         * (experimental) List of labels that will prevent auto-merging.
         * <p>
         * Default: ['do-not-merge']
         * <p>
         * @return {@code this}
         * @param blockingLabels List of labels that will prevent auto-merging. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder blockingLabels(final java.util.List<java.lang.String> blockingLabels) {
            this.options().blockingLabels(blockingLabels);
            return this;
        }

        /**
         * (experimental) Name of the mergify queue.
         * <p>
         * Default: 'default'
         * <p>
         * @return {@code this}
         * @param queueName Name of the mergify queue. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder queueName(final java.lang.String queueName) {
            this.options().queueName(queueName);
            return this;
        }

        /**
         * (experimental) Name of the mergify rule.
         * <p>
         * Default: 'Automatic merge on approval and successful build'
         * <p>
         * @return {@code this}
         * @param ruleName Name of the mergify rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder ruleName(final java.lang.String ruleName) {
            this.options().ruleName(ruleName);
            return this;
        }

        /**
         * @return a newly built instance of {@link io.github.cdklabs.projen.github.AutoMerge}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public io.github.cdklabs.projen.github.AutoMerge build() {
            return new io.github.cdklabs.projen.github.AutoMerge(
                this.github,
                this.options != null ? this.options.build() : null
            );
        }

        private io.github.cdklabs.projen.github.AutoMergeOptions.Builder options() {
            if (this.options == null) {
                this.options = new io.github.cdklabs.projen.github.AutoMergeOptions.Builder();
            }
            return this.options;
        }
    }
}
