package io.github.cdklabs.projen.gitlab;

/**
 * (experimental) References a local file or an artifact from another job to define the pipeline configuration.
 * <p>
 * @see <a href="https://docs.gitlab.com/ee/ci/yaml/#triggerinclude">https://docs.gitlab.com/ee/ci/yaml/#triggerinclude</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-28T17:20:29.292Z")
@software.amazon.jsii.Jsii(module = io.github.cdklabs.projen.$Module.class, fqn = "projen.gitlab.TriggerInclude")
@software.amazon.jsii.Jsii.Proxy(TriggerInclude.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface TriggerInclude extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Relative path to the generated YAML file which is extracted from the artifacts and used as the configuration for triggering the child pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getArtifact() {
        return null;
    }

    /**
     * (experimental) Relative path from repository root (<code>/</code>) to the pipeline configuration YAML file.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getFile() {
        return null;
    }

    /**
     * (experimental) Job name which generates the artifact.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getJob() {
        return null;
    }

    /**
     * (experimental) Relative path from local repository root (<code>/</code>) to the local YAML file to define the pipeline configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getLocal() {
        return null;
    }

    /**
     * (experimental) Path to another private project under the same GitLab instance, like <code>group/project</code> or <code>group/sub-group/project</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getProject() {
        return null;
    }

    /**
     * (experimental) Branch/Tag/Commit hash for the target project.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getRef() {
        return null;
    }

    /**
     * (experimental) Name of the template YAML file to use in the pipeline configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getTemplate() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link TriggerInclude}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TriggerInclude}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<TriggerInclude> {
        java.lang.String artifact;
        java.lang.String file;
        java.lang.String job;
        java.lang.String local;
        java.lang.String project;
        java.lang.String ref;
        java.lang.String template;

        /**
         * Sets the value of {@link TriggerInclude#getArtifact}
         * @param artifact Relative path to the generated YAML file which is extracted from the artifacts and used as the configuration for triggering the child pipeline.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder artifact(java.lang.String artifact) {
            this.artifact = artifact;
            return this;
        }

        /**
         * Sets the value of {@link TriggerInclude#getFile}
         * @param file Relative path from repository root (<code>/</code>) to the pipeline configuration YAML file.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder file(java.lang.String file) {
            this.file = file;
            return this;
        }

        /**
         * Sets the value of {@link TriggerInclude#getJob}
         * @param job Job name which generates the artifact.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder job(java.lang.String job) {
            this.job = job;
            return this;
        }

        /**
         * Sets the value of {@link TriggerInclude#getLocal}
         * @param local Relative path from local repository root (<code>/</code>) to the local YAML file to define the pipeline configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder local(java.lang.String local) {
            this.local = local;
            return this;
        }

        /**
         * Sets the value of {@link TriggerInclude#getProject}
         * @param project Path to another private project under the same GitLab instance, like <code>group/project</code> or <code>group/sub-group/project</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder project(java.lang.String project) {
            this.project = project;
            return this;
        }

        /**
         * Sets the value of {@link TriggerInclude#getRef}
         * @param ref Branch/Tag/Commit hash for the target project.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder ref(java.lang.String ref) {
            this.ref = ref;
            return this;
        }

        /**
         * Sets the value of {@link TriggerInclude#getTemplate}
         * @param template Name of the template YAML file to use in the pipeline configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder template(java.lang.String template) {
            this.template = template;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TriggerInclude}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public TriggerInclude build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TriggerInclude}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TriggerInclude {
        private final java.lang.String artifact;
        private final java.lang.String file;
        private final java.lang.String job;
        private final java.lang.String local;
        private final java.lang.String project;
        private final java.lang.String ref;
        private final java.lang.String template;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.artifact = software.amazon.jsii.Kernel.get(this, "artifact", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.file = software.amazon.jsii.Kernel.get(this, "file", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.job = software.amazon.jsii.Kernel.get(this, "job", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.local = software.amazon.jsii.Kernel.get(this, "local", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.project = software.amazon.jsii.Kernel.get(this, "project", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ref = software.amazon.jsii.Kernel.get(this, "ref", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.template = software.amazon.jsii.Kernel.get(this, "template", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.artifact = builder.artifact;
            this.file = builder.file;
            this.job = builder.job;
            this.local = builder.local;
            this.project = builder.project;
            this.ref = builder.ref;
            this.template = builder.template;
        }

        @Override
        public final java.lang.String getArtifact() {
            return this.artifact;
        }

        @Override
        public final java.lang.String getFile() {
            return this.file;
        }

        @Override
        public final java.lang.String getJob() {
            return this.job;
        }

        @Override
        public final java.lang.String getLocal() {
            return this.local;
        }

        @Override
        public final java.lang.String getProject() {
            return this.project;
        }

        @Override
        public final java.lang.String getRef() {
            return this.ref;
        }

        @Override
        public final java.lang.String getTemplate() {
            return this.template;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getArtifact() != null) {
                data.set("artifact", om.valueToTree(this.getArtifact()));
            }
            if (this.getFile() != null) {
                data.set("file", om.valueToTree(this.getFile()));
            }
            if (this.getJob() != null) {
                data.set("job", om.valueToTree(this.getJob()));
            }
            if (this.getLocal() != null) {
                data.set("local", om.valueToTree(this.getLocal()));
            }
            if (this.getProject() != null) {
                data.set("project", om.valueToTree(this.getProject()));
            }
            if (this.getRef() != null) {
                data.set("ref", om.valueToTree(this.getRef()));
            }
            if (this.getTemplate() != null) {
                data.set("template", om.valueToTree(this.getTemplate()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("projen.gitlab.TriggerInclude"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TriggerInclude.Jsii$Proxy that = (TriggerInclude.Jsii$Proxy) o;

            if (this.artifact != null ? !this.artifact.equals(that.artifact) : that.artifact != null) return false;
            if (this.file != null ? !this.file.equals(that.file) : that.file != null) return false;
            if (this.job != null ? !this.job.equals(that.job) : that.job != null) return false;
            if (this.local != null ? !this.local.equals(that.local) : that.local != null) return false;
            if (this.project != null ? !this.project.equals(that.project) : that.project != null) return false;
            if (this.ref != null ? !this.ref.equals(that.ref) : that.ref != null) return false;
            return this.template != null ? this.template.equals(that.template) : that.template == null;
        }

        @Override
        public final int hashCode() {
            int result = this.artifact != null ? this.artifact.hashCode() : 0;
            result = 31 * result + (this.file != null ? this.file.hashCode() : 0);
            result = 31 * result + (this.job != null ? this.job.hashCode() : 0);
            result = 31 * result + (this.local != null ? this.local.hashCode() : 0);
            result = 31 * result + (this.project != null ? this.project.hashCode() : 0);
            result = 31 * result + (this.ref != null ? this.ref.hashCode() : 0);
            result = 31 * result + (this.template != null ? this.template.hashCode() : 0);
            return result;
        }
    }
}
