package io.github.cdklabs.projen.javascript;

/**
 * (experimental) Options for <code>addBundle()</code>.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-28T17:20:29.305Z")
@software.amazon.jsii.Jsii(module = io.github.cdklabs.projen.$Module.class, fqn = "projen.javascript.AddBundleOptions")
@software.amazon.jsii.Jsii.Proxy(AddBundleOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface AddBundleOptions extends software.amazon.jsii.JsiiSerializable, io.github.cdklabs.projen.javascript.BundlingOptions {

    /**
     * (experimental) esbuild platform.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * "node"
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getPlatform();

    /**
     * (experimental) esbuild target.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * "node12"
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getTarget();

    /**
     * (experimental) Use this to insert an arbitrary string at the beginning of generated JavaScript files.
     * <p>
     * This is similar to footer which inserts at the end instead of the beginning.
     * <p>
     * This is commonly used to insert comments:
     * <p>
     * Default: - no comments are passed
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getBanner() {
        return null;
    }

    /**
     * (experimental) The charset to use for esbuild's output.
     * <p>
     * By default esbuild's output is ASCII-only. Any non-ASCII characters are escaped
     * using backslash escape sequences. Using escape sequences makes the generated output
     * slightly bigger, and also makes it harder to read. If you would like for esbuild to print
     * the original characters without using escape sequences, use <code>Charset.UTF8</code>.
     * <p>
     * Default: Charset.ASCII
     * <p>
     * @see <a href="https://esbuild.github.io/api/#charset">https://esbuild.github.io/api/#charset</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.javascript.Charset getCharset() {
        return null;
    }

    /**
     * (experimental) Replace global identifiers with constant expressions.
     * <p>
     * For example, <code>{ 'process.env.DEBUG': 'true' }</code>.
     * <p>
     * Another example, <code>{ 'process.env.API_KEY': JSON.stringify('xxx-xxxx-xxx') }</code>.
     * <p>
     * Default: - no replacements are made
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getDefine() {
        return null;
    }

    /**
     * (experimental) Build arguments to pass into esbuild.
     * <p>
     * For example, to add the <a href="https://esbuild.github.io/api/#log-limit">--log-limit</a> flag:
     * <p>
     * <blockquote><pre>
     * project.bundler.addBundle("./src/hello.ts", {
     *   platform: "node",
     *   target: "node18",
     *   sourcemap: true,
     *   format: "esm",
     *   esbuildArgs: {
     *     "--log-limit": "0",
     *   },
     * });
     * </pre></blockquote>
     * <p>
     * Default: - no additional esbuild arguments are passed
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> getEsbuildArgs() {
        return null;
    }

    /**
     * (experimental) Mark the output file as executable.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getExecutable() {
        return null;
    }

    /**
     * (experimental) Use this to insert an arbitrary string at the end of generated JavaScript files.
     * <p>
     * This is similar to banner which inserts at the beginning instead of the end.
     * <p>
     * This is commonly used to insert comments
     * <p>
     * Default: - no comments are passed
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getFooter() {
        return null;
    }

    /**
     * (experimental) Output format for the generated JavaScript files.
     * <p>
     * There are currently three possible values that can be configured: <code>"iife"</code>, <code>"cjs"</code>, and <code>"esm"</code>.
     * <p>
     * If not set (<code>undefined</code>), esbuild picks an output format for you based on <code>platform</code>:
     * <p>
     * <ul>
     * <li><code>"cjs"</code> if <code>platform</code> is <code>"node"</code></li>
     * <li><code>"iife"</code> if <code>platform</code> is <code>"browser"</code></li>
     * <li><code>"esm"</code> if <code>platform</code> is <code>"neutral"</code></li>
     * </ul>
     * <p>
     * Note: If making a bundle to run under node with ESM, set <code>format</code> to <code>"esm"</code> instead of setting <code>platform</code> to <code>"neutral"</code>.
     * <p>
     * Default: undefined
     * <p>
     * @see <a href="https://esbuild.github.io/api/#format">https://esbuild.github.io/api/#format</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getFormat() {
        return null;
    }

    /**
     * (experimental) This option allows you to automatically replace a global variable with an import from another file.
     * <p>
     * Default: - no code is injected
     * <p>
     * @see <a href="https://esbuild.github.io/api/#inject">https://esbuild.github.io/api/#inject</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInject() {
        return null;
    }

    /**
     * (experimental) Whether to preserve the original <code>name</code> values even in minified code.
     * <p>
     * In JavaScript the <code>name</code> property on functions and classes defaults to a
     * nearby identifier in the source code.
     * <p>
     * However, minification renames symbols to reduce code size and bundling
     * sometimes need to rename symbols to avoid collisions. That changes value of
     * the <code>name</code> property for many of these cases. This is usually fine because
     * the <code>name</code> property is normally only used for debugging. However, some
     * frameworks rely on the <code>name</code> property for registration and binding purposes.
     * If this is the case, you can enable this option to preserve the original
     * <code>name</code> values even in minified code.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getKeepNames() {
        return null;
    }

    /**
     * (experimental) Map of file extensions (without dot) and loaders to use for this file type.
     * <p>
     * Loaders are appended to the esbuild command by <code>--loader:.extension=loader</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getLoaders() {
        return null;
    }

    /**
     * (experimental) Log level for esbuild.
     * <p>
     * This is also propagated to the package manager and
     * applies to its specific install command.
     * <p>
     * Default: LogLevel.WARNING
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.javascript.BundleLogLevel getLogLevel() {
        return null;
    }

    /**
     * (experimental) How to determine the entry point for modules.
     * <p>
     * Try ['module', 'main'] to default to ES module versions.
     * <p>
     * Default: []
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getMainFields() {
        return null;
    }

    /**
     * (experimental) This option tells esbuild to write out a JSON file relative to output directory with metadata about the build.
     * <p>
     * The metadata in this JSON file follows this schema (specified using TypeScript syntax):
     * <p>
     * <blockquote><pre>
     * {
     *   outputs: {
     *     [path: string]: {
     *       bytes: number
     *       inputs: {
     *         [path: string]: { bytesInOutput: number }
     *       }
     *       imports: { path: string }[]
     *       exports: string[]
     *     }
     *   }
     * }
     * </pre></blockquote>
     * <p>
     * This data can then be analyzed by other tools. For example,
     * bundle buddy can consume esbuild's metadata format and generates a treemap visualization
     * of the modules in your bundle and how much space each one takes up.
     * <p>
     * Default: false
     * <p>
     * @see <a href="https://esbuild.github.io/api/#metafile">https://esbuild.github.io/api/#metafile</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getMetafile() {
        return null;
    }

    /**
     * (experimental) Whether to minify files when bundling.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getMinify() {
        return null;
    }

    /**
     * (experimental) Bundler output path relative to the asset's output directory.
     * <p>
     * Default: "index.js"
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getOutfile() {
        return null;
    }

    /**
     * (experimental) Source map mode to be used when bundling.
     * <p>
     * Default: SourceMapMode.DEFAULT
     * <p>
     * @see <a href="https://esbuild.github.io/api/#sourcemap">https://esbuild.github.io/api/#sourcemap</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.javascript.SourceMapMode getSourceMapMode() {
        return null;
    }

    /**
     * (experimental) Whether to include original source code in source maps when bundling.
     * <p>
     * Default: true
     * <p>
     * @see <a href="https://esbuild.github.io/api/#sources-content">https://esbuild.github.io/api/#sources-content</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSourcesContent() {
        return null;
    }

    /**
     * (experimental) The path of the tsconfig.json file to use for bundling.
     * <p>
     * Default: "tsconfig.json"
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getTsconfigPath() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AddBundleOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AddBundleOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<AddBundleOptions> {
        java.lang.String platform;
        java.lang.String target;
        java.lang.String banner;
        io.github.cdklabs.projen.javascript.Charset charset;
        java.util.Map<java.lang.String, java.lang.String> define;
        java.util.Map<java.lang.String, java.lang.Object> esbuildArgs;
        java.lang.Boolean executable;
        java.lang.String footer;
        java.lang.String format;
        java.util.List<java.lang.String> inject;
        java.lang.Boolean keepNames;
        java.util.Map<java.lang.String, java.lang.String> loaders;
        io.github.cdklabs.projen.javascript.BundleLogLevel logLevel;
        java.util.List<java.lang.String> mainFields;
        java.lang.Boolean metafile;
        java.lang.Boolean minify;
        java.lang.String outfile;
        io.github.cdklabs.projen.javascript.SourceMapMode sourceMapMode;
        java.lang.Boolean sourcesContent;
        java.lang.String tsconfigPath;
        java.util.List<java.lang.String> externals;
        java.lang.Boolean sourcemap;
        java.lang.Boolean watchTask;

        /**
         * Sets the value of {@link AddBundleOptions#getPlatform}
         * @param platform esbuild platform. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder platform(java.lang.String platform) {
            this.platform = platform;
            return this;
        }

        /**
         * Sets the value of {@link AddBundleOptions#getTarget}
         * @param target esbuild target. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder target(java.lang.String target) {
            this.target = target;
            return this;
        }

        /**
         * Sets the value of {@link AddBundleOptions#getBanner}
         * @param banner Use this to insert an arbitrary string at the beginning of generated JavaScript files.
         *               This is similar to footer which inserts at the end instead of the beginning.
         *               <p>
         *               This is commonly used to insert comments:
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder banner(java.lang.String banner) {
            this.banner = banner;
            return this;
        }

        /**
         * Sets the value of {@link AddBundleOptions#getCharset}
         * @param charset The charset to use for esbuild's output.
         *                By default esbuild's output is ASCII-only. Any non-ASCII characters are escaped
         *                using backslash escape sequences. Using escape sequences makes the generated output
         *                slightly bigger, and also makes it harder to read. If you would like for esbuild to print
         *                the original characters without using escape sequences, use <code>Charset.UTF8</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder charset(io.github.cdklabs.projen.javascript.Charset charset) {
            this.charset = charset;
            return this;
        }

        /**
         * Sets the value of {@link AddBundleOptions#getDefine}
         * @param define Replace global identifiers with constant expressions.
         *               For example, <code>{ 'process.env.DEBUG': 'true' }</code>.
         *               <p>
         *               Another example, <code>{ 'process.env.API_KEY': JSON.stringify('xxx-xxxx-xxx') }</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder define(java.util.Map<java.lang.String, java.lang.String> define) {
            this.define = define;
            return this;
        }

        /**
         * Sets the value of {@link AddBundleOptions#getEsbuildArgs}
         * @param esbuildArgs Build arguments to pass into esbuild.
         *                    For example, to add the <a href="https://esbuild.github.io/api/#log-limit">--log-limit</a> flag:
         *                    <p>
         *                    <blockquote><pre>
         *                    project.bundler.addBundle("./src/hello.ts", {
         *                      platform: "node",
         *                      target: "node18",
         *                      sourcemap: true,
         *                      format: "esm",
         *                      esbuildArgs: {
         *                        "--log-limit": "0",
         *                      },
         *                    });
         *                    </pre></blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder esbuildArgs(java.util.Map<java.lang.String, ? extends java.lang.Object> esbuildArgs) {
            this.esbuildArgs = (java.util.Map<java.lang.String, java.lang.Object>)esbuildArgs;
            return this;
        }

        /**
         * Sets the value of {@link AddBundleOptions#getExecutable}
         * @param executable Mark the output file as executable.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder executable(java.lang.Boolean executable) {
            this.executable = executable;
            return this;
        }

        /**
         * Sets the value of {@link AddBundleOptions#getFooter}
         * @param footer Use this to insert an arbitrary string at the end of generated JavaScript files.
         *               This is similar to banner which inserts at the beginning instead of the end.
         *               <p>
         *               This is commonly used to insert comments
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder footer(java.lang.String footer) {
            this.footer = footer;
            return this;
        }

        /**
         * Sets the value of {@link AddBundleOptions#getFormat}
         * @param format Output format for the generated JavaScript files.
         *               There are currently three possible values that can be configured: <code>"iife"</code>, <code>"cjs"</code>, and <code>"esm"</code>.
         *               <p>
         *               If not set (<code>undefined</code>), esbuild picks an output format for you based on <code>platform</code>:
         *               <p>
         *               <ul>
         *               <li><code>"cjs"</code> if <code>platform</code> is <code>"node"</code></li>
         *               <li><code>"iife"</code> if <code>platform</code> is <code>"browser"</code></li>
         *               <li><code>"esm"</code> if <code>platform</code> is <code>"neutral"</code></li>
         *               </ul>
         *               <p>
         *               Note: If making a bundle to run under node with ESM, set <code>format</code> to <code>"esm"</code> instead of setting <code>platform</code> to <code>"neutral"</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder format(java.lang.String format) {
            this.format = format;
            return this;
        }

        /**
         * Sets the value of {@link AddBundleOptions#getInject}
         * @param inject This option allows you to automatically replace a global variable with an import from another file.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder inject(java.util.List<java.lang.String> inject) {
            this.inject = inject;
            return this;
        }

        /**
         * Sets the value of {@link AddBundleOptions#getKeepNames}
         * @param keepNames Whether to preserve the original <code>name</code> values even in minified code.
         *                  In JavaScript the <code>name</code> property on functions and classes defaults to a
         *                  nearby identifier in the source code.
         *                  <p>
         *                  However, minification renames symbols to reduce code size and bundling
         *                  sometimes need to rename symbols to avoid collisions. That changes value of
         *                  the <code>name</code> property for many of these cases. This is usually fine because
         *                  the <code>name</code> property is normally only used for debugging. However, some
         *                  frameworks rely on the <code>name</code> property for registration and binding purposes.
         *                  If this is the case, you can enable this option to preserve the original
         *                  <code>name</code> values even in minified code.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder keepNames(java.lang.Boolean keepNames) {
            this.keepNames = keepNames;
            return this;
        }

        /**
         * Sets the value of {@link AddBundleOptions#getLoaders}
         * @param loaders Map of file extensions (without dot) and loaders to use for this file type.
         *                Loaders are appended to the esbuild command by <code>--loader:.extension=loader</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder loaders(java.util.Map<java.lang.String, java.lang.String> loaders) {
            this.loaders = loaders;
            return this;
        }

        /**
         * Sets the value of {@link AddBundleOptions#getLogLevel}
         * @param logLevel Log level for esbuild.
         *                 This is also propagated to the package manager and
         *                 applies to its specific install command.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder logLevel(io.github.cdklabs.projen.javascript.BundleLogLevel logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        /**
         * Sets the value of {@link AddBundleOptions#getMainFields}
         * @param mainFields How to determine the entry point for modules.
         *                   Try ['module', 'main'] to default to ES module versions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder mainFields(java.util.List<java.lang.String> mainFields) {
            this.mainFields = mainFields;
            return this;
        }

        /**
         * Sets the value of {@link AddBundleOptions#getMetafile}
         * @param metafile This option tells esbuild to write out a JSON file relative to output directory with metadata about the build.
         *                 The metadata in this JSON file follows this schema (specified using TypeScript syntax):
         *                 <p>
         *                 <blockquote><pre>
         *                 {
         *                   outputs: {
         *                     [path: string]: {
         *                       bytes: number
         *                       inputs: {
         *                         [path: string]: { bytesInOutput: number }
         *                       }
         *                       imports: { path: string }[]
         *                       exports: string[]
         *                     }
         *                   }
         *                 }
         *                 </pre></blockquote>
         *                 <p>
         *                 This data can then be analyzed by other tools. For example,
         *                 bundle buddy can consume esbuild's metadata format and generates a treemap visualization
         *                 of the modules in your bundle and how much space each one takes up.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder metafile(java.lang.Boolean metafile) {
            this.metafile = metafile;
            return this;
        }

        /**
         * Sets the value of {@link AddBundleOptions#getMinify}
         * @param minify Whether to minify files when bundling.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder minify(java.lang.Boolean minify) {
            this.minify = minify;
            return this;
        }

        /**
         * Sets the value of {@link AddBundleOptions#getOutfile}
         * @param outfile Bundler output path relative to the asset's output directory.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder outfile(java.lang.String outfile) {
            this.outfile = outfile;
            return this;
        }

        /**
         * Sets the value of {@link AddBundleOptions#getSourceMapMode}
         * @param sourceMapMode Source map mode to be used when bundling.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder sourceMapMode(io.github.cdklabs.projen.javascript.SourceMapMode sourceMapMode) {
            this.sourceMapMode = sourceMapMode;
            return this;
        }

        /**
         * Sets the value of {@link AddBundleOptions#getSourcesContent}
         * @param sourcesContent Whether to include original source code in source maps when bundling.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder sourcesContent(java.lang.Boolean sourcesContent) {
            this.sourcesContent = sourcesContent;
            return this;
        }

        /**
         * Sets the value of {@link AddBundleOptions#getTsconfigPath}
         * @param tsconfigPath The path of the tsconfig.json file to use for bundling.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder tsconfigPath(java.lang.String tsconfigPath) {
            this.tsconfigPath = tsconfigPath;
            return this;
        }

        /**
         * Sets the value of {@link AddBundleOptions#getExternals}
         * @param externals You can mark a file or a package as external to exclude it from your build.
         *                  Instead of being bundled, the import will be preserved (using require for
         *                  the iife and cjs formats and using import for the esm format) and will be
         *                  evaluated at run time instead.
         *                  <p>
         *                  This has several uses. First of all, it can be used to trim unnecessary
         *                  code from your bundle for a code path that you know will never be executed.
         *                  For example, a package may contain code that only runs in node but you will
         *                  only be using that package in the browser. It can also be used to import
         *                  code in node at run time from a package that cannot be bundled. For
         *                  example, the fsevents package contains a native extension, which esbuild
         *                  doesn't support.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder externals(java.util.List<java.lang.String> externals) {
            this.externals = externals;
            return this;
        }

        /**
         * Sets the value of {@link AddBundleOptions#getSourcemap}
         * @param sourcemap Include a source map in the bundle.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder sourcemap(java.lang.Boolean sourcemap) {
            this.sourcemap = sourcemap;
            return this;
        }

        /**
         * Sets the value of {@link AddBundleOptions#getWatchTask}
         * @param watchTask In addition to the <code>bundle:xyz</code> task, creates <code>bundle:xyz:watch</code> task which will invoke the same esbuild command with the <code>--watch</code> flag.
         *                  This can be used
         *                  to continusouly watch for changes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder watchTask(java.lang.Boolean watchTask) {
            this.watchTask = watchTask;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AddBundleOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public AddBundleOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AddBundleOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AddBundleOptions {
        private final java.lang.String platform;
        private final java.lang.String target;
        private final java.lang.String banner;
        private final io.github.cdklabs.projen.javascript.Charset charset;
        private final java.util.Map<java.lang.String, java.lang.String> define;
        private final java.util.Map<java.lang.String, java.lang.Object> esbuildArgs;
        private final java.lang.Boolean executable;
        private final java.lang.String footer;
        private final java.lang.String format;
        private final java.util.List<java.lang.String> inject;
        private final java.lang.Boolean keepNames;
        private final java.util.Map<java.lang.String, java.lang.String> loaders;
        private final io.github.cdklabs.projen.javascript.BundleLogLevel logLevel;
        private final java.util.List<java.lang.String> mainFields;
        private final java.lang.Boolean metafile;
        private final java.lang.Boolean minify;
        private final java.lang.String outfile;
        private final io.github.cdklabs.projen.javascript.SourceMapMode sourceMapMode;
        private final java.lang.Boolean sourcesContent;
        private final java.lang.String tsconfigPath;
        private final java.util.List<java.lang.String> externals;
        private final java.lang.Boolean sourcemap;
        private final java.lang.Boolean watchTask;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.platform = software.amazon.jsii.Kernel.get(this, "platform", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.target = software.amazon.jsii.Kernel.get(this, "target", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.banner = software.amazon.jsii.Kernel.get(this, "banner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.charset = software.amazon.jsii.Kernel.get(this, "charset", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.javascript.Charset.class));
            this.define = software.amazon.jsii.Kernel.get(this, "define", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.esbuildArgs = software.amazon.jsii.Kernel.get(this, "esbuildArgs", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.executable = software.amazon.jsii.Kernel.get(this, "executable", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.footer = software.amazon.jsii.Kernel.get(this, "footer", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.format = software.amazon.jsii.Kernel.get(this, "format", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.inject = software.amazon.jsii.Kernel.get(this, "inject", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.keepNames = software.amazon.jsii.Kernel.get(this, "keepNames", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.loaders = software.amazon.jsii.Kernel.get(this, "loaders", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.logLevel = software.amazon.jsii.Kernel.get(this, "logLevel", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.javascript.BundleLogLevel.class));
            this.mainFields = software.amazon.jsii.Kernel.get(this, "mainFields", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.metafile = software.amazon.jsii.Kernel.get(this, "metafile", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.minify = software.amazon.jsii.Kernel.get(this, "minify", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.outfile = software.amazon.jsii.Kernel.get(this, "outfile", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourceMapMode = software.amazon.jsii.Kernel.get(this, "sourceMapMode", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.javascript.SourceMapMode.class));
            this.sourcesContent = software.amazon.jsii.Kernel.get(this, "sourcesContent", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.tsconfigPath = software.amazon.jsii.Kernel.get(this, "tsconfigPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.externals = software.amazon.jsii.Kernel.get(this, "externals", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.sourcemap = software.amazon.jsii.Kernel.get(this, "sourcemap", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.watchTask = software.amazon.jsii.Kernel.get(this, "watchTask", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.platform = java.util.Objects.requireNonNull(builder.platform, "platform is required");
            this.target = java.util.Objects.requireNonNull(builder.target, "target is required");
            this.banner = builder.banner;
            this.charset = builder.charset;
            this.define = builder.define;
            this.esbuildArgs = (java.util.Map<java.lang.String, java.lang.Object>)builder.esbuildArgs;
            this.executable = builder.executable;
            this.footer = builder.footer;
            this.format = builder.format;
            this.inject = builder.inject;
            this.keepNames = builder.keepNames;
            this.loaders = builder.loaders;
            this.logLevel = builder.logLevel;
            this.mainFields = builder.mainFields;
            this.metafile = builder.metafile;
            this.minify = builder.minify;
            this.outfile = builder.outfile;
            this.sourceMapMode = builder.sourceMapMode;
            this.sourcesContent = builder.sourcesContent;
            this.tsconfigPath = builder.tsconfigPath;
            this.externals = builder.externals;
            this.sourcemap = builder.sourcemap;
            this.watchTask = builder.watchTask;
        }

        @Override
        public final java.lang.String getPlatform() {
            return this.platform;
        }

        @Override
        public final java.lang.String getTarget() {
            return this.target;
        }

        @Override
        public final java.lang.String getBanner() {
            return this.banner;
        }

        @Override
        public final io.github.cdklabs.projen.javascript.Charset getCharset() {
            return this.charset;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getDefine() {
            return this.define;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getEsbuildArgs() {
            return this.esbuildArgs;
        }

        @Override
        public final java.lang.Boolean getExecutable() {
            return this.executable;
        }

        @Override
        public final java.lang.String getFooter() {
            return this.footer;
        }

        @Override
        public final java.lang.String getFormat() {
            return this.format;
        }

        @Override
        public final java.util.List<java.lang.String> getInject() {
            return this.inject;
        }

        @Override
        public final java.lang.Boolean getKeepNames() {
            return this.keepNames;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getLoaders() {
            return this.loaders;
        }

        @Override
        public final io.github.cdklabs.projen.javascript.BundleLogLevel getLogLevel() {
            return this.logLevel;
        }

        @Override
        public final java.util.List<java.lang.String> getMainFields() {
            return this.mainFields;
        }

        @Override
        public final java.lang.Boolean getMetafile() {
            return this.metafile;
        }

        @Override
        public final java.lang.Boolean getMinify() {
            return this.minify;
        }

        @Override
        public final java.lang.String getOutfile() {
            return this.outfile;
        }

        @Override
        public final io.github.cdklabs.projen.javascript.SourceMapMode getSourceMapMode() {
            return this.sourceMapMode;
        }

        @Override
        public final java.lang.Boolean getSourcesContent() {
            return this.sourcesContent;
        }

        @Override
        public final java.lang.String getTsconfigPath() {
            return this.tsconfigPath;
        }

        @Override
        public final java.util.List<java.lang.String> getExternals() {
            return this.externals;
        }

        @Override
        public final java.lang.Boolean getSourcemap() {
            return this.sourcemap;
        }

        @Override
        public final java.lang.Boolean getWatchTask() {
            return this.watchTask;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("platform", om.valueToTree(this.getPlatform()));
            data.set("target", om.valueToTree(this.getTarget()));
            if (this.getBanner() != null) {
                data.set("banner", om.valueToTree(this.getBanner()));
            }
            if (this.getCharset() != null) {
                data.set("charset", om.valueToTree(this.getCharset()));
            }
            if (this.getDefine() != null) {
                data.set("define", om.valueToTree(this.getDefine()));
            }
            if (this.getEsbuildArgs() != null) {
                data.set("esbuildArgs", om.valueToTree(this.getEsbuildArgs()));
            }
            if (this.getExecutable() != null) {
                data.set("executable", om.valueToTree(this.getExecutable()));
            }
            if (this.getFooter() != null) {
                data.set("footer", om.valueToTree(this.getFooter()));
            }
            if (this.getFormat() != null) {
                data.set("format", om.valueToTree(this.getFormat()));
            }
            if (this.getInject() != null) {
                data.set("inject", om.valueToTree(this.getInject()));
            }
            if (this.getKeepNames() != null) {
                data.set("keepNames", om.valueToTree(this.getKeepNames()));
            }
            if (this.getLoaders() != null) {
                data.set("loaders", om.valueToTree(this.getLoaders()));
            }
            if (this.getLogLevel() != null) {
                data.set("logLevel", om.valueToTree(this.getLogLevel()));
            }
            if (this.getMainFields() != null) {
                data.set("mainFields", om.valueToTree(this.getMainFields()));
            }
            if (this.getMetafile() != null) {
                data.set("metafile", om.valueToTree(this.getMetafile()));
            }
            if (this.getMinify() != null) {
                data.set("minify", om.valueToTree(this.getMinify()));
            }
            if (this.getOutfile() != null) {
                data.set("outfile", om.valueToTree(this.getOutfile()));
            }
            if (this.getSourceMapMode() != null) {
                data.set("sourceMapMode", om.valueToTree(this.getSourceMapMode()));
            }
            if (this.getSourcesContent() != null) {
                data.set("sourcesContent", om.valueToTree(this.getSourcesContent()));
            }
            if (this.getTsconfigPath() != null) {
                data.set("tsconfigPath", om.valueToTree(this.getTsconfigPath()));
            }
            if (this.getExternals() != null) {
                data.set("externals", om.valueToTree(this.getExternals()));
            }
            if (this.getSourcemap() != null) {
                data.set("sourcemap", om.valueToTree(this.getSourcemap()));
            }
            if (this.getWatchTask() != null) {
                data.set("watchTask", om.valueToTree(this.getWatchTask()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("projen.javascript.AddBundleOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AddBundleOptions.Jsii$Proxy that = (AddBundleOptions.Jsii$Proxy) o;

            if (!platform.equals(that.platform)) return false;
            if (!target.equals(that.target)) return false;
            if (this.banner != null ? !this.banner.equals(that.banner) : that.banner != null) return false;
            if (this.charset != null ? !this.charset.equals(that.charset) : that.charset != null) return false;
            if (this.define != null ? !this.define.equals(that.define) : that.define != null) return false;
            if (this.esbuildArgs != null ? !this.esbuildArgs.equals(that.esbuildArgs) : that.esbuildArgs != null) return false;
            if (this.executable != null ? !this.executable.equals(that.executable) : that.executable != null) return false;
            if (this.footer != null ? !this.footer.equals(that.footer) : that.footer != null) return false;
            if (this.format != null ? !this.format.equals(that.format) : that.format != null) return false;
            if (this.inject != null ? !this.inject.equals(that.inject) : that.inject != null) return false;
            if (this.keepNames != null ? !this.keepNames.equals(that.keepNames) : that.keepNames != null) return false;
            if (this.loaders != null ? !this.loaders.equals(that.loaders) : that.loaders != null) return false;
            if (this.logLevel != null ? !this.logLevel.equals(that.logLevel) : that.logLevel != null) return false;
            if (this.mainFields != null ? !this.mainFields.equals(that.mainFields) : that.mainFields != null) return false;
            if (this.metafile != null ? !this.metafile.equals(that.metafile) : that.metafile != null) return false;
            if (this.minify != null ? !this.minify.equals(that.minify) : that.minify != null) return false;
            if (this.outfile != null ? !this.outfile.equals(that.outfile) : that.outfile != null) return false;
            if (this.sourceMapMode != null ? !this.sourceMapMode.equals(that.sourceMapMode) : that.sourceMapMode != null) return false;
            if (this.sourcesContent != null ? !this.sourcesContent.equals(that.sourcesContent) : that.sourcesContent != null) return false;
            if (this.tsconfigPath != null ? !this.tsconfigPath.equals(that.tsconfigPath) : that.tsconfigPath != null) return false;
            if (this.externals != null ? !this.externals.equals(that.externals) : that.externals != null) return false;
            if (this.sourcemap != null ? !this.sourcemap.equals(that.sourcemap) : that.sourcemap != null) return false;
            return this.watchTask != null ? this.watchTask.equals(that.watchTask) : that.watchTask == null;
        }

        @Override
        public final int hashCode() {
            int result = this.platform.hashCode();
            result = 31 * result + (this.target.hashCode());
            result = 31 * result + (this.banner != null ? this.banner.hashCode() : 0);
            result = 31 * result + (this.charset != null ? this.charset.hashCode() : 0);
            result = 31 * result + (this.define != null ? this.define.hashCode() : 0);
            result = 31 * result + (this.esbuildArgs != null ? this.esbuildArgs.hashCode() : 0);
            result = 31 * result + (this.executable != null ? this.executable.hashCode() : 0);
            result = 31 * result + (this.footer != null ? this.footer.hashCode() : 0);
            result = 31 * result + (this.format != null ? this.format.hashCode() : 0);
            result = 31 * result + (this.inject != null ? this.inject.hashCode() : 0);
            result = 31 * result + (this.keepNames != null ? this.keepNames.hashCode() : 0);
            result = 31 * result + (this.loaders != null ? this.loaders.hashCode() : 0);
            result = 31 * result + (this.logLevel != null ? this.logLevel.hashCode() : 0);
            result = 31 * result + (this.mainFields != null ? this.mainFields.hashCode() : 0);
            result = 31 * result + (this.metafile != null ? this.metafile.hashCode() : 0);
            result = 31 * result + (this.minify != null ? this.minify.hashCode() : 0);
            result = 31 * result + (this.outfile != null ? this.outfile.hashCode() : 0);
            result = 31 * result + (this.sourceMapMode != null ? this.sourceMapMode.hashCode() : 0);
            result = 31 * result + (this.sourcesContent != null ? this.sourcesContent.hashCode() : 0);
            result = 31 * result + (this.tsconfigPath != null ? this.tsconfigPath.hashCode() : 0);
            result = 31 * result + (this.externals != null ? this.externals.hashCode() : 0);
            result = 31 * result + (this.sourcemap != null ? this.sourcemap.hashCode() : 0);
            result = 31 * result + (this.watchTask != null ? this.watchTask.hashCode() : 0);
            return result;
        }
    }
}
