package io.github.cdklabs.projen.python;

/**
 * (experimental) Specifies a list of packages to be installed using pip.
 * <p>
 * @see <a href="https://pip.pypa.io/en/stable/reference/pip_install/#requirements-file-format">https://pip.pypa.io/en/stable/reference/pip_install/#requirements-file-format</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-28T17:20:29.398Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = io.github.cdklabs.projen.$Module.class, fqn = "projen.python.RequirementsFile")
public class RequirementsFile extends io.github.cdklabs.projen.FileBase {

    protected RequirementsFile(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected RequirementsFile(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param project This parameter is required.
     * @param filePath This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public RequirementsFile(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.Project project, final @org.jetbrains.annotations.NotNull java.lang.String filePath, final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.python.RequirementsFileOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(project, "project is required"), java.util.Objects.requireNonNull(filePath, "filePath is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * (experimental) Adds the specified packages provided in semver format.
     * <p>
     * Comment lines (start with <code>#</code>) are ignored.
     * <p>
     * @param packages Package version in format <code>&lt;module&gt;&#64;&lt;semver&gt;</code>. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addPackages(final @org.jetbrains.annotations.NotNull java.lang.String... packages) {
        software.amazon.jsii.Kernel.call(this, "addPackages", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(packages).toArray(Object[]::new));
    }

    /**
     * (experimental) Implemented by derived classes and returns the contents of the file to emit.
     * <p>
     * @param resolver This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    protected @org.jetbrains.annotations.Nullable java.lang.String synthesizeContent(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.IResolver resolver) {
        return software.amazon.jsii.Kernel.call(this, "synthesizeContent", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(resolver, "resolver is required") });
    }

    /**
     * (experimental) A fluent builder for {@link io.github.cdklabs.projen.python.RequirementsFile}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<io.github.cdklabs.projen.python.RequirementsFile> {
        /**
         * @return a new instance of {@link Builder}.
         * @param project This parameter is required.
         * @param filePath This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final io.github.cdklabs.projen.Project project, final java.lang.String filePath) {
            return new Builder(project, filePath);
        }

        private final io.github.cdklabs.projen.Project project;
        private final java.lang.String filePath;
        private final io.github.cdklabs.projen.python.RequirementsFileOptions.Builder options;

        private Builder(final io.github.cdklabs.projen.Project project, final java.lang.String filePath) {
            this.project = project;
            this.filePath = filePath;
            this.options = new io.github.cdklabs.projen.python.RequirementsFileOptions.Builder();
        }

        /**
         * (experimental) Provide a list of packages that can be dynamically updated.
         * <p>
         * @return {@code this}
         * @param packageProvider Provide a list of packages that can be dynamically updated. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder packageProvider(final io.github.cdklabs.projen.python.IPackageProvider packageProvider) {
            this.options.packageProvider(packageProvider);
            return this;
        }

        /**
         * @return a newly built instance of {@link io.github.cdklabs.projen.python.RequirementsFile}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public io.github.cdklabs.projen.python.RequirementsFile build() {
            return new io.github.cdklabs.projen.python.RequirementsFile(
                this.project,
                this.filePath,
                this.options.build()
            );
        }
    }
}
