package io.github.cdklabs.projen.release;

/**
 * (experimental) Publishing options for GitHub releases.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-28T17:20:29.401Z")
@software.amazon.jsii.Jsii(module = io.github.cdklabs.projen.$Module.class, fqn = "projen.release.GitHubReleasesPublishOptions")
@software.amazon.jsii.Jsii.Proxy(GitHubReleasesPublishOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface GitHubReleasesPublishOptions extends software.amazon.jsii.JsiiSerializable, io.github.cdklabs.projen.release.CommonPublishOptions {

    /**
     * (experimental) The location of an .md file (relative to <code>dist/</code>) that includes the changelog for the release.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * changelog.md
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getChangelogFile();

    /**
     * (experimental) The location of a text file (relative to <code>dist/</code>) that contains the release tag.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * releasetag.txt
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getReleaseTagFile();

    /**
     * (experimental) The location of a text file (relative to <code>dist/</code>) that contains the version number.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * version.txt
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getVersionFile();

    /**
     * @return a {@link Builder} of {@link GitHubReleasesPublishOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link GitHubReleasesPublishOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<GitHubReleasesPublishOptions> {
        java.lang.String changelogFile;
        java.lang.String releaseTagFile;
        java.lang.String versionFile;
        java.util.List<io.github.cdklabs.projen.github.workflows.JobStep> postPublishSteps;
        java.util.List<io.github.cdklabs.projen.github.workflows.JobStep> prePublishSteps;
        io.github.cdklabs.projen.github.workflows.Tools publishTools;

        /**
         * Sets the value of {@link GitHubReleasesPublishOptions#getChangelogFile}
         * @param changelogFile The location of an .md file (relative to <code>dist/</code>) that includes the changelog for the release. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder changelogFile(java.lang.String changelogFile) {
            this.changelogFile = changelogFile;
            return this;
        }

        /**
         * Sets the value of {@link GitHubReleasesPublishOptions#getReleaseTagFile}
         * @param releaseTagFile The location of a text file (relative to <code>dist/</code>) that contains the release tag. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder releaseTagFile(java.lang.String releaseTagFile) {
            this.releaseTagFile = releaseTagFile;
            return this;
        }

        /**
         * Sets the value of {@link GitHubReleasesPublishOptions#getVersionFile}
         * @param versionFile The location of a text file (relative to <code>dist/</code>) that contains the version number. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder versionFile(java.lang.String versionFile) {
            this.versionFile = versionFile;
            return this;
        }

        /**
         * Sets the value of {@link GitHubReleasesPublishOptions#getPostPublishSteps}
         * @param postPublishSteps Steps to execute after executing the publishing command.
         *                         These can be used
         *                         to add/update the release artifacts ot any other tasks needed.
         *                         <p>
         *                         Note that when using this in <code>publishToGitHubReleases</code> this will override steps added via <code>addGitHubPostPublishingSteps</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder postPublishSteps(java.util.List<? extends io.github.cdklabs.projen.github.workflows.JobStep> postPublishSteps) {
            this.postPublishSteps = (java.util.List<io.github.cdklabs.projen.github.workflows.JobStep>)postPublishSteps;
            return this;
        }

        /**
         * Sets the value of {@link GitHubReleasesPublishOptions#getPrePublishSteps}
         * @param prePublishSteps Steps to execute before executing the publishing command. These can be used to prepare the artifact for publishing if neede.
         *                        These steps are executed after <code>dist/</code> has been populated with the build
         *                        output.
         *                        <p>
         *                        Note that when using this in <code>publishToGitHubReleases</code> this will override steps added via <code>addGitHubPrePublishingSteps</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder prePublishSteps(java.util.List<? extends io.github.cdklabs.projen.github.workflows.JobStep> prePublishSteps) {
            this.prePublishSteps = (java.util.List<io.github.cdklabs.projen.github.workflows.JobStep>)prePublishSteps;
            return this;
        }

        /**
         * Sets the value of {@link GitHubReleasesPublishOptions#getPublishTools}
         * @param publishTools Additional tools to install in the publishing job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder publishTools(io.github.cdklabs.projen.github.workflows.Tools publishTools) {
            this.publishTools = publishTools;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GitHubReleasesPublishOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public GitHubReleasesPublishOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link GitHubReleasesPublishOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GitHubReleasesPublishOptions {
        private final java.lang.String changelogFile;
        private final java.lang.String releaseTagFile;
        private final java.lang.String versionFile;
        private final java.util.List<io.github.cdklabs.projen.github.workflows.JobStep> postPublishSteps;
        private final java.util.List<io.github.cdklabs.projen.github.workflows.JobStep> prePublishSteps;
        private final io.github.cdklabs.projen.github.workflows.Tools publishTools;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.changelogFile = software.amazon.jsii.Kernel.get(this, "changelogFile", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.releaseTagFile = software.amazon.jsii.Kernel.get(this, "releaseTagFile", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.versionFile = software.amazon.jsii.Kernel.get(this, "versionFile", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.postPublishSteps = software.amazon.jsii.Kernel.get(this, "postPublishSteps", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.github.workflows.JobStep.class)));
            this.prePublishSteps = software.amazon.jsii.Kernel.get(this, "prePublishSteps", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.github.workflows.JobStep.class)));
            this.publishTools = software.amazon.jsii.Kernel.get(this, "publishTools", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.github.workflows.Tools.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.changelogFile = java.util.Objects.requireNonNull(builder.changelogFile, "changelogFile is required");
            this.releaseTagFile = java.util.Objects.requireNonNull(builder.releaseTagFile, "releaseTagFile is required");
            this.versionFile = java.util.Objects.requireNonNull(builder.versionFile, "versionFile is required");
            this.postPublishSteps = (java.util.List<io.github.cdklabs.projen.github.workflows.JobStep>)builder.postPublishSteps;
            this.prePublishSteps = (java.util.List<io.github.cdklabs.projen.github.workflows.JobStep>)builder.prePublishSteps;
            this.publishTools = builder.publishTools;
        }

        @Override
        public final java.lang.String getChangelogFile() {
            return this.changelogFile;
        }

        @Override
        public final java.lang.String getReleaseTagFile() {
            return this.releaseTagFile;
        }

        @Override
        public final java.lang.String getVersionFile() {
            return this.versionFile;
        }

        @Override
        public final java.util.List<io.github.cdklabs.projen.github.workflows.JobStep> getPostPublishSteps() {
            return this.postPublishSteps;
        }

        @Override
        public final java.util.List<io.github.cdklabs.projen.github.workflows.JobStep> getPrePublishSteps() {
            return this.prePublishSteps;
        }

        @Override
        public final io.github.cdklabs.projen.github.workflows.Tools getPublishTools() {
            return this.publishTools;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("changelogFile", om.valueToTree(this.getChangelogFile()));
            data.set("releaseTagFile", om.valueToTree(this.getReleaseTagFile()));
            data.set("versionFile", om.valueToTree(this.getVersionFile()));
            if (this.getPostPublishSteps() != null) {
                data.set("postPublishSteps", om.valueToTree(this.getPostPublishSteps()));
            }
            if (this.getPrePublishSteps() != null) {
                data.set("prePublishSteps", om.valueToTree(this.getPrePublishSteps()));
            }
            if (this.getPublishTools() != null) {
                data.set("publishTools", om.valueToTree(this.getPublishTools()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("projen.release.GitHubReleasesPublishOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GitHubReleasesPublishOptions.Jsii$Proxy that = (GitHubReleasesPublishOptions.Jsii$Proxy) o;

            if (!changelogFile.equals(that.changelogFile)) return false;
            if (!releaseTagFile.equals(that.releaseTagFile)) return false;
            if (!versionFile.equals(that.versionFile)) return false;
            if (this.postPublishSteps != null ? !this.postPublishSteps.equals(that.postPublishSteps) : that.postPublishSteps != null) return false;
            if (this.prePublishSteps != null ? !this.prePublishSteps.equals(that.prePublishSteps) : that.prePublishSteps != null) return false;
            return this.publishTools != null ? this.publishTools.equals(that.publishTools) : that.publishTools == null;
        }

        @Override
        public final int hashCode() {
            int result = this.changelogFile.hashCode();
            result = 31 * result + (this.releaseTagFile.hashCode());
            result = 31 * result + (this.versionFile.hashCode());
            result = 31 * result + (this.postPublishSteps != null ? this.postPublishSteps.hashCode() : 0);
            result = 31 * result + (this.prePublishSteps != null ? this.prePublishSteps.hashCode() : 0);
            result = 31 * result + (this.publishTools != null ? this.publishTools.hashCode() : 0);
            return result;
        }
    }
}
