package io.github.cdklabs.projen.release;

/**
 * (experimental) Implements GitHub jobs for publishing modules to package managers.
 * <p>
 * Under the hood, it uses https://github.com/aws/publib
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-28T17:20:29.407Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = io.github.cdklabs.projen.$Module.class, fqn = "projen.release.Publisher")
public class Publisher extends io.github.cdklabs.projen.Component {

    protected Publisher(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Publisher(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PUBLISH_GIT_TASK_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(io.github.cdklabs.projen.release.Publisher.class, "PUBLISH_GIT_TASK_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param project This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Publisher(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.Project project, final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.release.PublisherOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(project, "project is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * (experimental) Adds post publishing steps for the GitHub release job.
     * <p>
     * @param steps The steps. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addGitHubPostPublishingSteps(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.github.workflows.JobStep... steps) {
        software.amazon.jsii.Kernel.call(this, "addGitHubPostPublishingSteps", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(steps).toArray(Object[]::new));
    }

    /**
     * (experimental) Adds pre publishing steps for the GitHub release job.
     * <p>
     * @param steps The steps. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addGitHubPrePublishingSteps(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.github.workflows.JobStep... steps) {
        software.amazon.jsii.Kernel.call(this, "addGitHubPrePublishingSteps", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(steps).toArray(Object[]::new));
    }

    /**
     * (experimental) Publish to git.
     * <p>
     * This includes generating a project-level changelog and release tags.
     * <p>
     * @param options Options. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.Task publishToGit(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.release.GitPublishOptions options) {
        return software.amazon.jsii.Kernel.call(this, "publishToGit", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.Task.class), new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * (experimental) Creates a GitHub Release.
     * <p>
     * @param options Options. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void publishToGitHubReleases(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.release.GitHubReleasesPublishOptions options) {
        software.amazon.jsii.Kernel.call(this, "publishToGitHubReleases", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * (experimental) Adds a go publishing job.
     * <p>
     * @param options Options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void publishToGo(final @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.release.GoPublishOptions options) {
        software.amazon.jsii.Kernel.call(this, "publishToGo", software.amazon.jsii.NativeType.VOID, new Object[] { options });
    }

    /**
     * (experimental) Adds a go publishing job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void publishToGo() {
        software.amazon.jsii.Kernel.call(this, "publishToGo", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * (experimental) Publishes artifacts from <code>java/**</code> to Maven.
     * <p>
     * @param options Options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void publishToMaven(final @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.release.MavenPublishOptions options) {
        software.amazon.jsii.Kernel.call(this, "publishToMaven", software.amazon.jsii.NativeType.VOID, new Object[] { options });
    }

    /**
     * (experimental) Publishes artifacts from <code>java/**</code> to Maven.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void publishToMaven() {
        software.amazon.jsii.Kernel.call(this, "publishToMaven", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * (experimental) Publishes artifacts from <code>js/**</code> to npm.
     * <p>
     * @param options Options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void publishToNpm(final @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.release.NpmPublishOptions options) {
        software.amazon.jsii.Kernel.call(this, "publishToNpm", software.amazon.jsii.NativeType.VOID, new Object[] { options });
    }

    /**
     * (experimental) Publishes artifacts from <code>js/**</code> to npm.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void publishToNpm() {
        software.amazon.jsii.Kernel.call(this, "publishToNpm", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * (experimental) Publishes artifacts from <code>dotnet/**</code> to NuGet Gallery.
     * <p>
     * @param options Options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void publishToNuget(final @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.release.NugetPublishOptions options) {
        software.amazon.jsii.Kernel.call(this, "publishToNuget", software.amazon.jsii.NativeType.VOID, new Object[] { options });
    }

    /**
     * (experimental) Publishes artifacts from <code>dotnet/**</code> to NuGet Gallery.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void publishToNuget() {
        software.amazon.jsii.Kernel.call(this, "publishToNuget", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * (experimental) Publishes wheel artifacts from <code>python</code> to PyPI.
     * <p>
     * @param options Options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void publishToPyPi(final @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.release.PyPiPublishOptions options) {
        software.amazon.jsii.Kernel.call(this, "publishToPyPi", software.amazon.jsii.NativeType.VOID, new Object[] { options });
    }

    /**
     * (experimental) Publishes wheel artifacts from <code>python</code> to PyPI.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void publishToPyPi() {
        software.amazon.jsii.Kernel.call(this, "publishToPyPi", software.amazon.jsii.NativeType.VOID);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String PUBLISH_GIT_TASK_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getArtifactName() {
        return software.amazon.jsii.Kernel.get(this, "artifactName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getBuildJobId() {
        return software.amazon.jsii.Kernel.get(this, "buildJobId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @deprecated use <code>publibVersion</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull java.lang.String getJsiiReleaseVersion() {
        return software.amazon.jsii.Kernel.get(this, "jsiiReleaseVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getPublibVersion() {
        return software.amazon.jsii.Kernel.get(this, "publibVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable java.lang.String getCondition() {
        return software.amazon.jsii.Kernel.get(this, "condition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A fluent builder for {@link io.github.cdklabs.projen.release.Publisher}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<io.github.cdklabs.projen.release.Publisher> {
        /**
         * @return a new instance of {@link Builder}.
         * @param project This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final io.github.cdklabs.projen.Project project) {
            return new Builder(project);
        }

        private final io.github.cdklabs.projen.Project project;
        private final io.github.cdklabs.projen.release.PublisherOptions.Builder options;

        private Builder(final io.github.cdklabs.projen.Project project) {
            this.project = project;
            this.options = new io.github.cdklabs.projen.release.PublisherOptions.Builder();
        }

        /**
         * (experimental) The name of the artifact to download (e.g. <code>dist</code>).
         * <p>
         * The artifact is expected to include a subdirectory for each release target:
         * <code>go</code> (GitHub), <code>dotnet</code> (NuGet), <code>java</code> (Maven), <code>js</code> (npm), <code>python</code>
         * (PyPI).
         * <p>
         * @return {@code this}
         * @see <a href="https://github.com/aws/publib">https://github.com/aws/publib</a>
         * @param artifactName The name of the artifact to download (e.g. <code>dist</code>). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder artifactName(final java.lang.String artifactName) {
            this.options.artifactName(artifactName);
            return this;
        }

        /**
         * (experimental) The job ID that produces the build artifacts.
         * <p>
         * All publish jobs will take a dependency on this job.
         * <p>
         * @return {@code this}
         * @param buildJobId The job ID that produces the build artifacts. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder buildJobId(final java.lang.String buildJobId) {
            this.options.buildJobId(buildJobId);
            return this;
        }

        /**
         * (experimental) A GitHub workflow expression used as a condition for publishers.
         * <p>
         * Default: - no condition
         * <p>
         * @return {@code this}
         * @param condition A GitHub workflow expression used as a condition for publishers. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder condition(final java.lang.String condition) {
            this.options.condition(condition);
            return this;
        }

        /**
         * (experimental) Do not actually publish, only print the commands that would be executed instead.
         * <p>
         * Useful if you wish to block all publishing from a single option.
         * <p>
         * @return {@code this}
         * @param dryRun Do not actually publish, only print the commands that would be executed instead. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder dryRun(final java.lang.Boolean dryRun) {
            this.options.dryRun(dryRun);
            return this;
        }

        /**
         * (experimental) Create an issue when a publish task fails.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param failureIssue Create an issue when a publish task fails. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder failureIssue(final java.lang.Boolean failureIssue) {
            this.options.failureIssue(failureIssue);
            return this;
        }

        /**
         * (experimental) The label to apply to the issue marking failed publish tasks.
         * <p>
         * Only applies if <code>failureIssue</code> is true.
         * <p>
         * Default: "failed-release"
         * <p>
         * @return {@code this}
         * @param failureIssueLabel The label to apply to the issue marking failed publish tasks. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder failureIssueLabel(final java.lang.String failureIssueLabel) {
            this.options.failureIssueLabel(failureIssueLabel);
            return this;
        }

        /**
         * @return {@code this}
         * @deprecated use <code>publibVersion</code> instead
         * @param jsiiReleaseVersion This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder jsiiReleaseVersion(final java.lang.String jsiiReleaseVersion) {
            this.options.jsiiReleaseVersion(jsiiReleaseVersion);
            return this;
        }

        /**
         * (experimental) Version requirement for <code>publib</code>.
         * <p>
         * Default: "latest"
         * <p>
         * @return {@code this}
         * @param publibVersion Version requirement for <code>publib</code>. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder publibVersion(final java.lang.String publibVersion) {
            this.options.publibVersion(publibVersion);
            return this;
        }

        /**
         * (experimental) Define publishing tasks that can be executed manually as well as workflows.
         * <p>
         * Normally, publishing only happens within automated workflows. Enable this
         * in order to create a publishing task for each publishing activity.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param publishTasks Define publishing tasks that can be executed manually as well as workflows. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder publishTasks(final java.lang.Boolean publishTasks) {
            this.options.publishTasks(publishTasks);
            return this;
        }

        /**
         * (experimental) Container image to use for GitHub workflows.
         * <p>
         * Default: - default image
         * <p>
         * @return {@code this}
         * @param workflowContainerImage Container image to use for GitHub workflows. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder workflowContainerImage(final java.lang.String workflowContainerImage) {
            this.options.workflowContainerImage(workflowContainerImage);
            return this;
        }

        /**
         * (experimental) Node version to setup in GitHub workflows if any node-based CLI utilities are needed.
         * <p>
         * For example <code>publib</code>, the CLI projen uses to publish releases,
         * is an npm library.
         * <p>
         * Default: 18.x
         * <p>
         * @return {@code this}
         * @param workflowNodeVersion Node version to setup in GitHub workflows if any node-based CLI utilities are needed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder workflowNodeVersion(final java.lang.String workflowNodeVersion) {
            this.options.workflowNodeVersion(workflowNodeVersion);
            return this;
        }

        /**
         * (experimental) Github Runner selection labels.
         * <p>
         * Default: ["ubuntu-latest"]
         * <p>
         * @return {@code this}
         * @param workflowRunsOn Github Runner selection labels. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder workflowRunsOn(final java.util.List<java.lang.String> workflowRunsOn) {
            this.options.workflowRunsOn(workflowRunsOn);
            return this;
        }

        /**
         * (experimental) Github Runner Group selection options.
         * <p>
         * @return {@code this}
         * @param workflowRunsOnGroup Github Runner Group selection options. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder workflowRunsOnGroup(final io.github.cdklabs.projen.GroupRunnerOptions workflowRunsOnGroup) {
            this.options.workflowRunsOnGroup(workflowRunsOnGroup);
            return this;
        }

        /**
         * @return a newly built instance of {@link io.github.cdklabs.projen.release.Publisher}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public io.github.cdklabs.projen.release.Publisher build() {
            return new io.github.cdklabs.projen.release.Publisher(
                this.project,
                this.options.build()
            );
        }
    }
}
