package io.github.cdklabs.projen.release;

/**
 * (experimental) Manages releases (currently through GitHub workflows).
 * <p>
 * By default, no branches are released. To add branches, call <code>addBranch()</code>.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-28T17:20:29.409Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = io.github.cdklabs.projen.$Module.class, fqn = "projen.release.Release")
public class Release extends io.github.cdklabs.projen.Component {

    protected Release(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Release(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        ANTI_TAMPER_CMD = software.amazon.jsii.JsiiObject.jsiiStaticGet(io.github.cdklabs.projen.release.Release.class, "ANTI_TAMPER_CMD", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope should be part of the project the Release belongs to. This parameter is required.
     * @param options options to configure the Release Component. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Release(final @org.jetbrains.annotations.NotNull software.constructs.IConstruct scope, final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.release.ReleaseOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * (experimental) Returns the <code>Release</code> component of a project or <code>undefined</code> if the project does not have a Release component.
     * <p>
     * @param project This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.Nullable io.github.cdklabs.projen.release.Release of(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.Project project) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(io.github.cdklabs.projen.release.Release.class, "of", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.release.Release.class), new Object[] { java.util.Objects.requireNonNull(project, "project is required") });
    }

    /**
     * (experimental) Adds a release branch.
     * <p>
     * It is a git branch from which releases are published. If a project has more than one release
     * branch, we require that <code>majorVersion</code> is also specified for the primary branch in order to
     * ensure branches always release the correct version.
     * <p>
     * @param branch The branch to monitor (e.g. <code>main</code>, <code>v2.x</code>). This parameter is required.
     * @param options Branch definition. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addBranch(final @org.jetbrains.annotations.NotNull java.lang.String branch, final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.release.BranchOptions options) {
        software.amazon.jsii.Kernel.call(this, "addBranch", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(branch, "branch is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * (experimental) Adds jobs to all release workflows.
     * <p>
     * @param jobs The jobs to add (name =&gt; job). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addJobs(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, io.github.cdklabs.projen.github.workflows.Job> jobs) {
        software.amazon.jsii.Kernel.call(this, "addJobs", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(jobs, "jobs is required") });
    }

    /**
     * (experimental) Called before synthesis.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void preSynthesize() {
        software.amazon.jsii.Kernel.call(this, "preSynthesize", software.amazon.jsii.NativeType.VOID);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String ANTI_TAMPER_CMD;

    /**
     * (experimental) Location of build artifacts.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getArtifactsDirectory() {
        return software.amazon.jsii.Kernel.get(this, "artifactsDirectory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Retrieve all release branch names.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getBranches() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "branches", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * (experimental) Package publisher.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.release.Publisher getPublisher() {
        return software.amazon.jsii.Kernel.get(this, "publisher", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.release.Publisher.class));
    }

    /**
     * (experimental) A fluent builder for {@link io.github.cdklabs.projen.release.Release}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<io.github.cdklabs.projen.release.Release> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope should be part of the project the Release belongs to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.IConstruct scope) {
            return new Builder(scope);
        }

        private final software.constructs.IConstruct scope;
        private final io.github.cdklabs.projen.release.ReleaseOptions.Builder options;

        private Builder(final software.constructs.IConstruct scope) {
            this.scope = scope;
            this.options = new io.github.cdklabs.projen.release.ReleaseOptions.Builder();
        }

        /**
         * (experimental) Version requirement of <code>publib</code> which is used to publish modules to npm.
         * <p>
         * Default: "latest"
         * <p>
         * @return {@code this}
         * @param jsiiReleaseVersion Version requirement of <code>publib</code> which is used to publish modules to npm. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder jsiiReleaseVersion(final java.lang.String jsiiReleaseVersion) {
            this.options.jsiiReleaseVersion(jsiiReleaseVersion);
            return this;
        }

        /**
         * (experimental) Major version to release from the default branch.
         * <p>
         * If this is specified, we bump the latest version of this major version line.
         * If not specified, we bump the global latest version.
         * <p>
         * Default: - Major version is not enforced.
         * <p>
         * @return {@code this}
         * @param majorVersion Major version to release from the default branch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder majorVersion(final java.lang.Number majorVersion) {
            this.options.majorVersion(majorVersion);
            return this;
        }

        /**
         * (experimental) Minimal Major version to release.
         * <p>
         * This can be useful to set to 1, as breaking changes before the 1.x major
         * release are not incrementing the major version number.
         * <p>
         * Can not be set together with <code>majorVersion</code>.
         * <p>
         * Default: - No minimum version is being enforced
         * <p>
         * @return {@code this}
         * @param minMajorVersion Minimal Major version to release. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder minMajorVersion(final java.lang.Number minMajorVersion) {
            this.options.minMajorVersion(minMajorVersion);
            return this;
        }

        /**
         * (experimental) The npmDistTag to use when publishing from the default branch.
         * <p>
         * To set the npm dist-tag for release branches, set the <code>npmDistTag</code> property
         * for each branch.
         * <p>
         * Default: "latest"
         * <p>
         * @return {@code this}
         * @param npmDistTag The npmDistTag to use when publishing from the default branch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder npmDistTag(final java.lang.String npmDistTag) {
            this.options.npmDistTag(npmDistTag);
            return this;
        }

        /**
         * (experimental) Steps to execute after build as part of the release workflow.
         * <p>
         * Default: []
         * <p>
         * @return {@code this}
         * @param postBuildSteps Steps to execute after build as part of the release workflow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder postBuildSteps(final java.util.List<? extends io.github.cdklabs.projen.github.workflows.JobStep> postBuildSteps) {
            this.options.postBuildSteps(postBuildSteps);
            return this;
        }

        /**
         * (experimental) Bump versions from the default branch as pre-releases (e.g. "beta", "alpha", "pre").
         * <p>
         * Default: - normal semantic versions
         * <p>
         * @return {@code this}
         * @param prerelease Bump versions from the default branch as pre-releases (e.g. "beta", "alpha", "pre"). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder prerelease(final java.lang.String prerelease) {
            this.options.prerelease(prerelease);
            return this;
        }

        /**
         * (experimental) Instead of actually publishing to package managers, just print the publishing command.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param publishDryRun Instead of actually publishing to package managers, just print the publishing command. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder publishDryRun(final java.lang.Boolean publishDryRun) {
            this.options.publishDryRun(publishDryRun);
            return this;
        }

        /**
         * (experimental) Define publishing tasks that can be executed manually as well as workflows.
         * <p>
         * Normally, publishing only happens within automated workflows. Enable this
         * in order to create a publishing task for each publishing activity.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param publishTasks Define publishing tasks that can be executed manually as well as workflows. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder publishTasks(final java.lang.Boolean publishTasks) {
            this.options.publishTasks(publishTasks);
            return this;
        }

        /**
         * (experimental) Find commits that should be considered releasable Used to decide if a release is required.
         * <p>
         * Default: ReleasableCommits.everyCommit()
         * <p>
         * @return {@code this}
         * @param releasableCommits Find commits that should be considered releasable Used to decide if a release is required. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder releasableCommits(final io.github.cdklabs.projen.ReleasableCommits releasableCommits) {
            this.options.releasableCommits(releasableCommits);
            return this;
        }

        /**
         * (experimental) Defines additional release branches.
         * <p>
         * A workflow will be created for each
         * release branch which will publish releases from commits in this branch.
         * Each release branch <em>must</em> be assigned a major version number which is used
         * to enforce that versions published from that branch always use that major
         * version. If multiple branches are used, the <code>majorVersion</code> field must also
         * be provided for the default branch.
         * <p>
         * Default: - no additional branches are used for release. you can use
         * `addBranch()` to add additional branches.
         * <p>
         * @return {@code this}
         * @param releaseBranches Defines additional release branches. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder releaseBranches(final java.util.Map<java.lang.String, ? extends io.github.cdklabs.projen.release.BranchOptions> releaseBranches) {
            this.options.releaseBranches(releaseBranches);
            return this;
        }

        /**
         * (deprecated) Automatically release new versions every commit to one of branches in <code>releaseBranches</code>.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @deprecated Use <code>releaseTrigger: ReleaseTrigger.continuous()</code> instead
         * @param releaseEveryCommit Automatically release new versions every commit to one of branches in <code>releaseBranches</code>. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder releaseEveryCommit(final java.lang.Boolean releaseEveryCommit) {
            this.options.releaseEveryCommit(releaseEveryCommit);
            return this;
        }

        /**
         * (experimental) Create a github issue on every failed publishing task.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param releaseFailureIssue Create a github issue on every failed publishing task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder releaseFailureIssue(final java.lang.Boolean releaseFailureIssue) {
            this.options.releaseFailureIssue(releaseFailureIssue);
            return this;
        }

        /**
         * (experimental) The label to apply to issues indicating publish failures.
         * <p>
         * Only applies if <code>releaseFailureIssue</code> is true.
         * <p>
         * Default: "failed-release"
         * <p>
         * @return {@code this}
         * @param releaseFailureIssueLabel The label to apply to issues indicating publish failures. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder releaseFailureIssueLabel(final java.lang.String releaseFailureIssueLabel) {
            this.options.releaseFailureIssueLabel(releaseFailureIssueLabel);
            return this;
        }

        /**
         * (deprecated) CRON schedule to trigger new releases.
         * <p>
         * Default: - no scheduled releases
         * <p>
         * @return {@code this}
         * @deprecated Use <code>releaseTrigger: ReleaseTrigger.scheduled()</code> instead
         * @param releaseSchedule CRON schedule to trigger new releases. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder releaseSchedule(final java.lang.String releaseSchedule) {
            this.options.releaseSchedule(releaseSchedule);
            return this;
        }

        /**
         * (experimental) Automatically add the given prefix to release tags. Useful if you are releasing on multiple branches with overlapping version numbers.
         * <p>
         * Note: this prefix is used to detect the latest tagged version
         * when bumping, so if you change this on a project with an existing version
         * history, you may need to manually tag your latest release
         * with the new prefix.
         * <p>
         * Default: "v"
         * <p>
         * @return {@code this}
         * @param releaseTagPrefix Automatically add the given prefix to release tags. Useful if you are releasing on multiple branches with overlapping version numbers. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder releaseTagPrefix(final java.lang.String releaseTagPrefix) {
            this.options.releaseTagPrefix(releaseTagPrefix);
            return this;
        }

        /**
         * (experimental) The release trigger to use.
         * <p>
         * Default: - Continuous releases (`ReleaseTrigger.continuous()`)
         * <p>
         * @return {@code this}
         * @param releaseTrigger The release trigger to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder releaseTrigger(final io.github.cdklabs.projen.release.ReleaseTrigger releaseTrigger) {
            this.options.releaseTrigger(releaseTrigger);
            return this;
        }

        /**
         * (experimental) The name of the default release workflow.
         * <p>
         * Default: "release"
         * <p>
         * @return {@code this}
         * @param releaseWorkflowName The name of the default release workflow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder releaseWorkflowName(final java.lang.String releaseWorkflowName) {
            this.options.releaseWorkflowName(releaseWorkflowName);
            return this;
        }

        /**
         * (experimental) A set of workflow steps to execute in order to setup the workflow container.
         * <p>
         * @return {@code this}
         * @param releaseWorkflowSetupSteps A set of workflow steps to execute in order to setup the workflow container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder releaseWorkflowSetupSteps(final java.util.List<? extends io.github.cdklabs.projen.github.workflows.JobStep> releaseWorkflowSetupSteps) {
            this.options.releaseWorkflowSetupSteps(releaseWorkflowSetupSteps);
            return this;
        }

        /**
         * (experimental) Custom configuration used when creating changelog with standard-version package.
         * <p>
         * Given values either append to default configuration or overwrite values in it.
         * <p>
         * Default: - standard configuration applicable for GitHub repositories
         * <p>
         * @return {@code this}
         * @param versionrcOptions Custom configuration used when creating changelog with standard-version package. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder versionrcOptions(final java.util.Map<java.lang.String, ? extends java.lang.Object> versionrcOptions) {
            this.options.versionrcOptions(versionrcOptions);
            return this;
        }

        /**
         * (experimental) Container image to use for GitHub workflows.
         * <p>
         * Default: - default image
         * <p>
         * @return {@code this}
         * @param workflowContainerImage Container image to use for GitHub workflows. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder workflowContainerImage(final java.lang.String workflowContainerImage) {
            this.options.workflowContainerImage(workflowContainerImage);
            return this;
        }

        /**
         * (experimental) Github Runner selection labels.
         * <p>
         * Default: ["ubuntu-latest"]
         * <p>
         * @return {@code this}
         * @param workflowRunsOn Github Runner selection labels. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder workflowRunsOn(final java.util.List<java.lang.String> workflowRunsOn) {
            this.options.workflowRunsOn(workflowRunsOn);
            return this;
        }

        /**
         * (experimental) Github Runner Group selection options.
         * <p>
         * @return {@code this}
         * @param workflowRunsOnGroup Github Runner Group selection options. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder workflowRunsOnGroup(final io.github.cdklabs.projen.GroupRunnerOptions workflowRunsOnGroup) {
            this.options.workflowRunsOnGroup(workflowRunsOnGroup);
            return this;
        }

        /**
         * (experimental) A directory which will contain build artifacts.
         * <p>
         * Default: "dist"
         * <p>
         * @return {@code this}
         * @param artifactsDirectory A directory which will contain build artifacts. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder artifactsDirectory(final java.lang.String artifactsDirectory) {
            this.options.artifactsDirectory(artifactsDirectory);
            return this;
        }

        /**
         * (experimental) The default branch name to release from.
         * <p>
         * Use <code>majorVersion</code> to restrict this branch to only publish releases with a
         * specific major version.
         * <p>
         * You can add additional branches using <code>addBranch()</code>.
         * <p>
         * @return {@code this}
         * @param branch The default branch name to release from. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder branch(final java.lang.String branch) {
            this.options.branch(branch);
            return this;
        }

        /**
         * (experimental) The task to execute in order to create the release artifacts.
         * <p>
         * Artifacts are
         * expected to reside under <code>artifactsDirectory</code> (defaults to <code>dist/</code>) once
         * build is complete.
         * <p>
         * @return {@code this}
         * @param task The task to execute in order to create the release artifacts. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder task(final io.github.cdklabs.projen.Task task) {
            this.options.task(task);
            return this;
        }

        /**
         * (experimental) A name of a .json file to set the <code>version</code> field in after a bump.
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>
         * "package.json"
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @param versionFile A name of a .json file to set the <code>version</code> field in after a bump. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder versionFile(final java.lang.String versionFile) {
            this.options.versionFile(versionFile);
            return this;
        }

        /**
         * (experimental) Create a GitHub release for each release.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param githubRelease Create a GitHub release for each release. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder githubRelease(final java.lang.Boolean githubRelease) {
            this.options.githubRelease(githubRelease);
            return this;
        }

        /**
         * (experimental) Node version to setup in GitHub workflows if any node-based CLI utilities are needed.
         * <p>
         * For example <code>publib</code>, the CLI projen uses to publish releases,
         * is an npm library.
         * <p>
         * Default: 18.x
         * <p>
         * @return {@code this}
         * @param workflowNodeVersion Node version to setup in GitHub workflows if any node-based CLI utilities are needed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder workflowNodeVersion(final java.lang.String workflowNodeVersion) {
            this.options.workflowNodeVersion(workflowNodeVersion);
            return this;
        }

        /**
         * (experimental) Permissions granted to the release workflow job.
         * <p>
         * Default: `{ contents: JobPermission.WRITE }`
         * <p>
         * @return {@code this}
         * @param workflowPermissions Permissions granted to the release workflow job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder workflowPermissions(final io.github.cdklabs.projen.github.workflows.JobPermissions workflowPermissions) {
            this.options.workflowPermissions(workflowPermissions);
            return this;
        }

        /**
         * @return a newly built instance of {@link io.github.cdklabs.projen.release.Release}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public io.github.cdklabs.projen.release.Release build() {
            return new io.github.cdklabs.projen.release.Release(
                this.scope,
                this.options.build()
            );
        }
    }
}
