/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdklabs.projen.github;

import io.github.cdklabs.projen.$Module;
import io.github.cdklabs.projen.Component;
import io.github.cdklabs.projen.github.DependabotAllow;
import io.github.cdklabs.projen.github.DependabotGroup;
import io.github.cdklabs.projen.github.DependabotIgnore;
import io.github.cdklabs.projen.github.DependabotOptions;
import io.github.cdklabs.projen.github.DependabotRegistry;
import io.github.cdklabs.projen.github.DependabotScheduleInterval;
import io.github.cdklabs.projen.github.GitHub;
import io.github.cdklabs.projen.github.VersioningStrategy;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="projen.github.Dependabot")
public class Dependabot
extends Component {
    protected Dependabot(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Dependabot(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Dependabot(@NotNull GitHub github, @Nullable DependabotOptions options) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(github, "github is required"), options});
    }

    public Dependabot(@NotNull GitHub github) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(github, "github is required")});
    }

    public void addAllow(@NotNull String dependencyName) {
        Kernel.call((Object)((Object)this), (String)"addAllow", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(dependencyName, "dependencyName is required")});
    }

    public void addIgnore(@NotNull String dependencyName, String ... versions) {
        Kernel.call((Object)((Object)this), (String)"addIgnore", (NativeType)NativeType.VOID, (Object[])Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(dependencyName, "dependencyName is required")}), Arrays.stream(versions)).toArray(Object[]::new));
    }

    @NotNull
    public Object getConfig() {
        return Kernel.get((Object)((Object)this), (String)"config", (NativeType)NativeType.forClass(Object.class));
    }

    @NotNull
    public Boolean getIgnoresProjen() {
        return (Boolean)Kernel.get((Object)((Object)this), (String)"ignoresProjen", (NativeType)NativeType.forClass(Boolean.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Dependabot> {
        private final GitHub github;
        private DependabotOptions.Builder options;

        public static Builder create(GitHub github) {
            return new Builder(github);
        }

        private Builder(GitHub github) {
            this.github = github;
        }

        public Builder allow(List<? extends DependabotAllow> allow) {
            this.options().allow(allow);
            return this;
        }

        public Builder assignees(List<String> assignees) {
            this.options().assignees(assignees);
            return this;
        }

        public Builder groups(Map<String, ? extends DependabotGroup> groups) {
            this.options().groups(groups);
            return this;
        }

        public Builder ignore(List<? extends DependabotIgnore> ignore) {
            this.options().ignore(ignore);
            return this;
        }

        public Builder ignoreProjen(Boolean ignoreProjen) {
            this.options().ignoreProjen(ignoreProjen);
            return this;
        }

        public Builder labels(List<String> labels) {
            this.options().labels(labels);
            return this;
        }

        public Builder openPullRequestsLimit(Number openPullRequestsLimit) {
            this.options().openPullRequestsLimit(openPullRequestsLimit);
            return this;
        }

        public Builder registries(Map<String, ? extends DependabotRegistry> registries) {
            this.options().registries(registries);
            return this;
        }

        public Builder reviewers(List<String> reviewers) {
            this.options().reviewers(reviewers);
            return this;
        }

        public Builder scheduleInterval(DependabotScheduleInterval scheduleInterval) {
            this.options().scheduleInterval(scheduleInterval);
            return this;
        }

        public Builder versioningStrategy(VersioningStrategy versioningStrategy) {
            this.options().versioningStrategy(versioningStrategy);
            return this;
        }

        public Dependabot build() {
            return new Dependabot(this.github, this.options != null ? this.options.build() : null);
        }

        private DependabotOptions.Builder options() {
            if (this.options == null) {
                this.options = new DependabotOptions.Builder();
            }
            return this.options;
        }
    }
}

