/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdklabs.projen.github;

import io.github.cdklabs.projen.$Module;
import io.github.cdklabs.projen.Component;
import io.github.cdklabs.projen.Project;
import io.github.cdklabs.projen.github.Dependabot;
import io.github.cdklabs.projen.github.DependabotOptions;
import io.github.cdklabs.projen.github.GitHubActionsProvider;
import io.github.cdklabs.projen.github.GitHubOptions;
import io.github.cdklabs.projen.github.GithubCredentials;
import io.github.cdklabs.projen.github.GithubWorkflow;
import io.github.cdklabs.projen.github.Mergify;
import io.github.cdklabs.projen.github.MergifyOptions;
import io.github.cdklabs.projen.github.PullRequestLintOptions;
import io.github.cdklabs.projen.github.PullRequestTemplate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="projen.github.GitHub")
public class GitHub
extends Component {
    protected GitHub(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected GitHub(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public GitHub(@NotNull Project project, @Nullable GitHubOptions options) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(project, "project is required"), options});
    }

    public GitHub(@NotNull Project project) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(project, "project is required")});
    }

    @Nullable
    public static GitHub of(@NotNull Project project) {
        return (GitHub)((Object)JsiiObject.jsiiStaticCall(GitHub.class, (String)"of", (NativeType)NativeType.forClass(GitHub.class), (Object[])new Object[]{Objects.requireNonNull(project, "project is required")}));
    }

    @NotNull
    public Dependabot addDependabot(@Nullable DependabotOptions options) {
        return (Dependabot)((Object)Kernel.call((Object)((Object)this), (String)"addDependabot", (NativeType)NativeType.forClass(Dependabot.class), (Object[])new Object[]{options}));
    }

    @NotNull
    public Dependabot addDependabot() {
        return (Dependabot)((Object)Kernel.call((Object)((Object)this), (String)"addDependabot", (NativeType)NativeType.forClass(Dependabot.class), (Object[])new Object[0]));
    }

    @NotNull
    public PullRequestTemplate addPullRequestTemplate(String ... content) {
        return (PullRequestTemplate)((Object)Kernel.call((Object)((Object)this), (String)"addPullRequestTemplate", (NativeType)NativeType.forClass(PullRequestTemplate.class), (Object[])Arrays.stream(content).toArray(Object[]::new)));
    }

    @NotNull
    public GithubWorkflow addWorkflow(@NotNull String name) {
        return (GithubWorkflow)((Object)Kernel.call((Object)((Object)this), (String)"addWorkflow", (NativeType)NativeType.forClass(GithubWorkflow.class), (Object[])new Object[]{Objects.requireNonNull(name, "name is required")}));
    }

    @Nullable
    public GithubWorkflow tryFindWorkflow(@NotNull String name) {
        return (GithubWorkflow)((Object)Kernel.call((Object)((Object)this), (String)"tryFindWorkflow", (NativeType)NativeType.forClass(GithubWorkflow.class), (Object[])new Object[]{Objects.requireNonNull(name, "name is required")}));
    }

    @NotNull
    public GitHubActionsProvider getActions() {
        return (GitHubActionsProvider)((Object)Kernel.get((Object)((Object)this), (String)"actions", (NativeType)NativeType.forClass(GitHubActionsProvider.class)));
    }

    @NotNull
    public Boolean getDownloadLfs() {
        return (Boolean)Kernel.get((Object)((Object)this), (String)"downloadLfs", (NativeType)NativeType.forClass(Boolean.class));
    }

    @NotNull
    public GithubCredentials getProjenCredentials() {
        return (GithubCredentials)((Object)Kernel.get((Object)((Object)this), (String)"projenCredentials", (NativeType)NativeType.forClass(GithubCredentials.class)));
    }

    @NotNull
    public List<GithubWorkflow> getWorkflows() {
        return Collections.unmodifiableList((List)Kernel.get((Object)((Object)this), (String)"workflows", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(GithubWorkflow.class))));
    }

    @NotNull
    public Boolean getWorkflowsEnabled() {
        return (Boolean)Kernel.get((Object)((Object)this), (String)"workflowsEnabled", (NativeType)NativeType.forClass(Boolean.class));
    }

    @Nullable
    public Mergify getMergify() {
        return (Mergify)((Object)Kernel.get((Object)((Object)this), (String)"mergify", (NativeType)NativeType.forClass(Mergify.class)));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<GitHub> {
        private final Project project;
        private GitHubOptions.Builder options;

        public static Builder create(Project project) {
            return new Builder(project);
        }

        private Builder(Project project) {
            this.project = project;
        }

        public Builder downloadLfs(Boolean downloadLfs) {
            this.options().downloadLfs(downloadLfs);
            return this;
        }

        public Builder mergify(Boolean mergify) {
            this.options().mergify(mergify);
            return this;
        }

        public Builder mergifyOptions(MergifyOptions mergifyOptions) {
            this.options().mergifyOptions(mergifyOptions);
            return this;
        }

        public Builder projenCredentials(GithubCredentials projenCredentials) {
            this.options().projenCredentials(projenCredentials);
            return this;
        }

        @Deprecated
        public Builder projenTokenSecret(String projenTokenSecret) {
            this.options().projenTokenSecret(projenTokenSecret);
            return this;
        }

        public Builder pullRequestLint(Boolean pullRequestLint) {
            this.options().pullRequestLint(pullRequestLint);
            return this;
        }

        public Builder pullRequestLintOptions(PullRequestLintOptions pullRequestLintOptions) {
            this.options().pullRequestLintOptions(pullRequestLintOptions);
            return this;
        }

        public Builder workflows(Boolean workflows) {
            this.options().workflows(workflows);
            return this;
        }

        public GitHub build() {
            return new GitHub(this.project, this.options != null ? this.options.build() : null);
        }

        private GitHubOptions.Builder options() {
            if (this.options == null) {
                this.options = new GitHubOptions.Builder();
            }
            return this.options;
        }
    }
}

