/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdklabs.projen.javascript;

import io.github.cdklabs.projen.$Module;
import io.github.cdklabs.projen.Component;
import io.github.cdklabs.projen.JsonFile;
import io.github.cdklabs.projen.Project;
import io.github.cdklabs.projen.javascript.JestConfigOptions;
import io.github.cdklabs.projen.javascript.JestOptions;
import io.github.cdklabs.projen.javascript.JestReporter;
import io.github.cdklabs.projen.javascript.NodeProject;
import io.github.cdklabs.projen.javascript.UpdateSnapshot;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.jsii.Configuration;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="projen.javascript.Jest")
public class Jest
extends Component {
    protected Jest(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Jest(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Jest(@NotNull NodeProject project, @Nullable JestOptions options) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(project, "project is required"), options});
    }

    public Jest(@NotNull NodeProject project) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(project, "project is required")});
    }

    @Nullable
    public static Jest of(@NotNull Project project) {
        return (Jest)((Object)JsiiObject.jsiiStaticCall(Jest.class, (String)"of", (NativeType)NativeType.forClass(Jest.class), (Object[])new Object[]{Objects.requireNonNull(project, "project is required")}));
    }

    public void addIgnorePattern(@NotNull String pattern) {
        Kernel.call((Object)((Object)this), (String)"addIgnorePattern", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(pattern, "pattern is required")});
    }

    public void addModuleNameMappers(@NotNull Map<String, Object> moduleNameMapperAdditions) {
        if (Configuration.getRuntimeTypeChecking()) {
            if (!(moduleNameMapperAdditions.keySet().toArray()[0] instanceof String)) {
                throw new IllegalArgumentException("Expected " + "moduleNameMapperAdditions" + ".keySet()" + " to contain class String; received " + moduleNameMapperAdditions.keySet().toArray()[0].getClass());
            }
            for (Map.Entry<String, Object> __item_957536 : moduleNameMapperAdditions.entrySet()) {
                Object __val_957536 = __item_957536.getValue();
                if (!(__val_957536 instanceof String) && !(__val_957536 instanceof List)) {
                    throw new IllegalArgumentException("Expected " + "moduleNameMapperAdditions" + ".get(\"" + __item_957536.getKey() + "\")" + " to be one of: java.lang.String, java.util.List<java.lang.String>; received " + __val_957536.getClass());
                }
                if (!(__val_957536 instanceof List)) continue;
                List __cast_e54f08 = (List)__val_957536;
                for (int __idx_e7d804 = 0; __idx_e7d804 < __cast_e54f08.size(); ++__idx_e7d804) {
                    String string = (String)__cast_e54f08.get(__idx_e7d804);
                }
            }
        }
        Kernel.call((Object)((Object)this), (String)"addModuleNameMappers", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(moduleNameMapperAdditions, "moduleNameMapperAdditions is required")});
    }

    public void addModulePaths(String ... modulePaths) {
        Kernel.call((Object)((Object)this), (String)"addModulePaths", (NativeType)NativeType.VOID, (Object[])Arrays.stream(modulePaths).toArray(Object[]::new));
    }

    public void addReporter(@NotNull JestReporter reporter) {
        Kernel.call((Object)((Object)this), (String)"addReporter", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(reporter, "reporter is required")});
    }

    public void addRoots(String ... roots) {
        Kernel.call((Object)((Object)this), (String)"addRoots", (NativeType)NativeType.VOID, (Object[])Arrays.stream(roots).toArray(Object[]::new));
    }

    public void addSetupFile(@NotNull String file) {
        Kernel.call((Object)((Object)this), (String)"addSetupFile", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(file, "file is required")});
    }

    public void addSetupFileAfterEnv(@NotNull String file) {
        Kernel.call((Object)((Object)this), (String)"addSetupFileAfterEnv", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(file, "file is required")});
    }

    public void addSnapshotResolver(@NotNull String file) {
        Kernel.call((Object)((Object)this), (String)"addSnapshotResolver", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(file, "file is required")});
    }

    public void addTestMatch(@NotNull String pattern) {
        Kernel.call((Object)((Object)this), (String)"addTestMatch", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(pattern, "pattern is required")});
    }

    public void addWatchIgnorePattern(@NotNull String pattern) {
        Kernel.call((Object)((Object)this), (String)"addWatchIgnorePattern", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(pattern, "pattern is required")});
    }

    @NotNull
    public Object getConfig() {
        return Kernel.get((Object)((Object)this), (String)"config", (NativeType)NativeType.forClass(Object.class));
    }

    @NotNull
    public String getJestVersion() {
        return (String)Kernel.get((Object)((Object)this), (String)"jestVersion", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public JsonFile getFile() {
        return (JsonFile)((Object)Kernel.get((Object)((Object)this), (String)"file", (NativeType)NativeType.forClass(JsonFile.class)));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Jest> {
        private final NodeProject project;
        private JestOptions.Builder options;

        public static Builder create(NodeProject project) {
            return new Builder(project);
        }

        private Builder(NodeProject project) {
            this.project = project;
        }

        public Builder configFilePath(String configFilePath) {
            this.options().configFilePath(configFilePath);
            return this;
        }

        @Deprecated
        public Builder coverage(Boolean coverage) {
            this.options().coverage(coverage);
            return this;
        }

        public Builder coverageText(Boolean coverageText) {
            this.options().coverageText(coverageText);
            return this;
        }

        public Builder extraCliOptions(List<String> extraCliOptions) {
            this.options().extraCliOptions(extraCliOptions);
            return this;
        }

        @Deprecated
        public Builder ignorePatterns(List<String> ignorePatterns) {
            this.options().ignorePatterns(ignorePatterns);
            return this;
        }

        public Builder jestConfig(JestConfigOptions jestConfig) {
            this.options().jestConfig(jestConfig);
            return this;
        }

        public Builder jestVersion(String jestVersion) {
            this.options().jestVersion(jestVersion);
            return this;
        }

        public Builder junitReporting(Boolean junitReporting) {
            this.options().junitReporting(junitReporting);
            return this;
        }

        public Builder preserveDefaultReporters(Boolean preserveDefaultReporters) {
            this.options().preserveDefaultReporters(preserveDefaultReporters);
            return this;
        }

        public Builder updateSnapshot(UpdateSnapshot updateSnapshot) {
            this.options().updateSnapshot(updateSnapshot);
            return this;
        }

        public Jest build() {
            return new Jest(this.project, this.options != null ? this.options.build() : null);
        }

        private JestOptions.Builder options() {
            if (this.options == null) {
                this.options = new JestOptions.Builder();
            }
            return this.options;
        }
    }
}

