/*
 * Decompiled with CFR 0.152.
 */
package io.github.censodev.jwtprovider;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import io.github.censodev.jwtprovider.CanAuth;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.io.Deserializer;
import io.jsonwebtoken.io.Serializer;
import io.jsonwebtoken.jackson.io.JacksonDeserializer;
import io.jsonwebtoken.jackson.io.JacksonSerializer;
import io.jsonwebtoken.security.Keys;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.time.Instant;
import java.util.Date;
import java.util.Map;
import lombok.NonNull;

public class JwtProvider {
    private static final String CREDENTIAL_CLAIM_KEY = "credentials";
    @NonNull
    private String secret;
    private Integer defaultExpireInMs;
    private SignatureAlgorithm signatureAlgorithm;
    private ObjectMapper jsonMapper;

    public static JwtProviderBuilder secret(String secret) {
        return JwtProvider.builder().secret(secret);
    }

    private static JwtProviderBuilder builder() {
        return new JwtProviderBuilder();
    }

    public Object getSubject(String token) {
        return this.getClaims(token).getSubject();
    }

    public <T extends CanAuth> T getCredential(String token, Class<T> credentialsType) {
        Map credInMap = (Map)this.getClaims(token).get(CREDENTIAL_CLAIM_KEY, Map.class);
        return (T)((CanAuth)this.jsonMapper.convertValue((Object)credInMap, credentialsType));
    }

    public void verify(String token) throws JwtException {
        Jwts.parserBuilder().setSigningKey(this.getKey()).build().parseClaimsJws(token);
    }

    public <T extends CanAuth> String generate(T canAuth) {
        return this.generate(canAuth, this.defaultExpireInMs);
    }

    public <T extends CanAuth> String generate(T canAuth, Integer expireInMillisecond) {
        Instant now = Instant.now();
        Instant expiredInstant = now.plusMillis(expireInMillisecond.intValue());
        return Jwts.builder().serializeToJsonWith((Serializer)new JacksonSerializer(this.jsonMapper)).setSubject(canAuth.subject().toString()).claim(CREDENTIAL_CLAIM_KEY, canAuth).setIssuedAt(Date.from(now)).setExpiration(Date.from(expiredInstant)).signWith(this.getKey(), this.signatureAlgorithm).compact();
    }

    private Key getKey() {
        return Keys.hmacShaKeyFor((byte[])this.secret.getBytes(StandardCharsets.UTF_8));
    }

    private Claims getClaims(String token) {
        return (Claims)Jwts.parserBuilder().deserializeJsonWith((Deserializer)new JacksonDeserializer(this.jsonMapper)).setSigningKey(this.getKey()).build().parseClaimsJws(token).getBody();
    }

    private static Integer $default$defaultExpireInMs() {
        return 3600000;
    }

    private static SignatureAlgorithm $default$signatureAlgorithm() {
        return SignatureAlgorithm.HS256;
    }

    private static ObjectMapper $default$jsonMapper() {
        return ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES})).build();
    }

    JwtProvider(@NonNull String secret, Integer defaultExpireInMs, SignatureAlgorithm signatureAlgorithm, ObjectMapper jsonMapper) {
        if (secret == null) {
            throw new NullPointerException("secret is marked non-null but is null");
        }
        this.secret = secret;
        this.defaultExpireInMs = defaultExpireInMs;
        this.signatureAlgorithm = signatureAlgorithm;
        this.jsonMapper = jsonMapper;
    }

    public JwtProviderBuilder toBuilder() {
        return new JwtProviderBuilder().secret(this.secret).defaultExpireInMs(this.defaultExpireInMs).signatureAlgorithm(this.signatureAlgorithm).jsonMapper(this.jsonMapper);
    }

    @NonNull
    public String getSecret() {
        return this.secret;
    }

    public Integer getDefaultExpireInMs() {
        return this.defaultExpireInMs;
    }

    public SignatureAlgorithm getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public ObjectMapper getJsonMapper() {
        return this.jsonMapper;
    }

    public static class JwtProviderBuilder {
        private String secret;
        private boolean defaultExpireInMs$set;
        private Integer defaultExpireInMs$value;
        private boolean signatureAlgorithm$set;
        private SignatureAlgorithm signatureAlgorithm$value;
        private boolean jsonMapper$set;
        private ObjectMapper jsonMapper$value;

        JwtProviderBuilder() {
        }

        public JwtProviderBuilder secret(@NonNull String secret) {
            if (secret == null) {
                throw new NullPointerException("secret is marked non-null but is null");
            }
            this.secret = secret;
            return this;
        }

        public JwtProviderBuilder defaultExpireInMs(Integer defaultExpireInMs) {
            this.defaultExpireInMs$value = defaultExpireInMs;
            this.defaultExpireInMs$set = true;
            return this;
        }

        public JwtProviderBuilder signatureAlgorithm(SignatureAlgorithm signatureAlgorithm) {
            this.signatureAlgorithm$value = signatureAlgorithm;
            this.signatureAlgorithm$set = true;
            return this;
        }

        public JwtProviderBuilder jsonMapper(ObjectMapper jsonMapper) {
            this.jsonMapper$value = jsonMapper;
            this.jsonMapper$set = true;
            return this;
        }

        public JwtProvider build() {
            Integer defaultExpireInMs$value = this.defaultExpireInMs$value;
            if (!this.defaultExpireInMs$set) {
                defaultExpireInMs$value = JwtProvider.$default$defaultExpireInMs();
            }
            SignatureAlgorithm signatureAlgorithm$value = this.signatureAlgorithm$value;
            if (!this.signatureAlgorithm$set) {
                signatureAlgorithm$value = JwtProvider.$default$signatureAlgorithm();
            }
            ObjectMapper jsonMapper$value = this.jsonMapper$value;
            if (!this.jsonMapper$set) {
                jsonMapper$value = JwtProvider.$default$jsonMapper();
            }
            return new JwtProvider(this.secret, defaultExpireInMs$value, signatureAlgorithm$value, jsonMapper$value);
        }

        public String toString() {
            return "JwtProvider.JwtProviderBuilder(secret=" + this.secret + ", defaultExpireInMs$value=" + this.defaultExpireInMs$value + ", signatureAlgorithm$value=" + this.signatureAlgorithm$value + ", jsonMapper$value=" + this.jsonMapper$value + ")";
        }
    }
}

