/*
 * Decompiled with CFR 0.152.
 */
package io.github.centrifugal.centrifuge;

import com.google.protobuf.ByteString;
import io.github.centrifugal.centrifuge.ClientInfo;
import io.github.centrifugal.centrifuge.ClientState;
import io.github.centrifugal.centrifuge.CompletionCallback;
import io.github.centrifugal.centrifuge.ConnectedEvent;
import io.github.centrifugal.centrifuge.ConnectingEvent;
import io.github.centrifugal.centrifuge.ConnectionTokenEvent;
import io.github.centrifugal.centrifuge.DisconnectedEvent;
import io.github.centrifugal.centrifuge.Dns;
import io.github.centrifugal.centrifuge.DuplicateSubscriptionException;
import io.github.centrifugal.centrifuge.ErrorEvent;
import io.github.centrifugal.centrifuge.EventListener;
import io.github.centrifugal.centrifuge.HistoryOptions;
import io.github.centrifugal.centrifuge.HistoryResult;
import io.github.centrifugal.centrifuge.JoinEvent;
import io.github.centrifugal.centrifuge.LeaveEvent;
import io.github.centrifugal.centrifuge.MessageEvent;
import io.github.centrifugal.centrifuge.Options;
import io.github.centrifugal.centrifuge.PresenceResult;
import io.github.centrifugal.centrifuge.PresenceStatsResult;
import io.github.centrifugal.centrifuge.Publication;
import io.github.centrifugal.centrifuge.PublicationEvent;
import io.github.centrifugal.centrifuge.PublishResult;
import io.github.centrifugal.centrifuge.RPCResult;
import io.github.centrifugal.centrifuge.RefreshError;
import io.github.centrifugal.centrifuge.ReplyError;
import io.github.centrifugal.centrifuge.ResultCallback;
import io.github.centrifugal.centrifuge.ServerJoinEvent;
import io.github.centrifugal.centrifuge.ServerLeaveEvent;
import io.github.centrifugal.centrifuge.ServerPublicationEvent;
import io.github.centrifugal.centrifuge.ServerSubscribedEvent;
import io.github.centrifugal.centrifuge.ServerSubscribingEvent;
import io.github.centrifugal.centrifuge.ServerSubscription;
import io.github.centrifugal.centrifuge.ServerUnsubscribedEvent;
import io.github.centrifugal.centrifuge.StreamPosition;
import io.github.centrifugal.centrifuge.Subscription;
import io.github.centrifugal.centrifuge.SubscriptionEventListener;
import io.github.centrifugal.centrifuge.SubscriptionState;
import io.github.centrifugal.centrifuge.TokenError;
import io.github.centrifugal.centrifuge.internal.backoff.Backoff;
import io.github.centrifugal.centrifuge.internal.protocol.Protocol;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java8.util.concurrent.CompletableFuture;
import okhttp3.Credentials;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;

public class Client {
    private WebSocket ws;
    private final String endpoint;
    private final Options opts;
    private String token;
    private ByteString data;
    private final EventListener listener;
    private final Map<Integer, CompletableFuture<Protocol.Reply>> futures = new ConcurrentHashMap<Integer, CompletableFuture<Protocol.Reply>>();
    private final Map<Integer, Protocol.Command> connectCommands = new ConcurrentHashMap<Integer, Protocol.Command>();
    private final Map<Integer, Protocol.Command> connectAsyncCommands = new ConcurrentHashMap<Integer, Protocol.Command>();
    private volatile ClientState state = ClientState.DISCONNECTED;
    private final Map<String, Subscription> subs = new ConcurrentHashMap<String, Subscription>();
    private final Map<String, ServerSubscription> serverSubs = new ConcurrentHashMap<String, ServerSubscription>();
    private final Backoff backoff;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private int pingInterval;
    private boolean sendPong;
    private ScheduledFuture<?> pingTask;
    private ScheduledFuture<?> refreshTask;
    private ScheduledFuture<?> reconnectTask;
    private int reconnectAttempts = 0;
    private boolean refreshRequired = false;
    private static final int NORMAL_CLOSURE_STATUS = 1000;
    private static final int MESSAGE_SIZE_LIMIT_EXCEEDED_STATUS = 1009;
    static final int DISCONNECTED_DISCONNECT_CALLED = 0;
    static final int DISCONNECTED_UNAUTHORIZED = 1;
    static final int DISCONNECTED_BAD_PROTOCOL = 2;
    static final int DISCONNECTED_MESSAGE_SIZE_LIMIT = 3;
    static final int CONNECTING_CONNECT_CALLED = 0;
    static final int CONNECTING_TRANSPORT_CLOSED = 1;
    static final int CONNECTING_NO_PING = 2;
    static final int CONNECTING_SUBSCRIBE_TIMEOUT = 3;
    static final int CONNECTING_UNSUBSCRIBE_ERROR = 4;
    static final int SUBSCRIBING_SUBSCRIBE_CALLED = 0;
    static final int SUBSCRIBING_TRANSPORT_CLOSED = 1;
    static final int UNSUBSCRIBED_UNSUBSCRIBE_CALLED = 0;
    static final int UNSUBSCRIBED_UNAUTHORIZED = 1;
    static final int UNSUBSCRIBED_CLIENT_CLOSED = 2;
    private int _id = 0;

    Options getOpts() {
        return this.opts;
    }

    ExecutorService getExecutor() {
        return this.executor;
    }

    ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    public Client(String endpoint, Options opts, EventListener listener) {
        this.endpoint = endpoint;
        this.opts = opts;
        this.listener = listener;
        this.backoff = new Backoff();
        this.token = opts.getToken();
        if (opts.getData() != null) {
            this.data = ByteString.copyFrom((byte[])opts.getData());
        }
    }

    void setState(ClientState state) {
        this.state = state;
    }

    public ClientState getState() {
        return this.state;
    }

    private int getNextId() {
        return ++this._id;
    }

    public void connect() {
        this.executor.submit(() -> {
            if (this.getState() == ClientState.CONNECTED || this.getState() == ClientState.CONNECTING) {
                return;
            }
            this.reconnectAttempts = 0;
            this.setState(ClientState.CONNECTING);
            ConnectingEvent event = new ConnectingEvent(0, "connect called");
            this.listener.onConnecting(this, event);
            this._connect();
        });
    }

    public void disconnect() {
        this.executor.submit(() -> this.processDisconnect(0, "disconnect called", false));
    }

    public boolean close(long awaitMilliseconds) throws InterruptedException {
        this.disconnect();
        this.executor.shutdown();
        this.scheduler.shutdownNow();
        if (awaitMilliseconds > 0L) {
            return this.executor.awaitTermination(awaitMilliseconds, TimeUnit.MILLISECONDS);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processDisconnect(int code, String reason, Boolean shouldReconnect) {
        boolean needEvent;
        if (this.getState() == ClientState.DISCONNECTED || this.getState() == ClientState.CLOSED) {
            return;
        }
        ClientState previousState = this.getState();
        if (this.pingTask != null) {
            this.pingTask.cancel(true);
            this.pingTask = null;
        }
        if (this.refreshTask != null) {
            this.refreshTask.cancel(true);
            this.refreshTask = null;
        }
        if (this.reconnectTask != null) {
            this.reconnectTask.cancel(true);
            this.reconnectTask = null;
        }
        if (shouldReconnect.booleanValue()) {
            needEvent = previousState != ClientState.CONNECTING;
            this.setState(ClientState.CONNECTING);
        } else {
            needEvent = previousState != ClientState.DISCONNECTED;
            this.setState(ClientState.DISCONNECTED);
        }
        Iterator<Map.Entry<String, ServerSubscription>> iterator = this.subs;
        synchronized (iterator) {
            for (Map.Entry<String, Subscription> entry : this.subs.entrySet()) {
                Subscription sub = entry.getValue();
                if (sub.getState() == SubscriptionState.UNSUBSCRIBED) continue;
                sub.moveToSubscribing(1, "transport closed");
            }
        }
        for (Map.Entry entry : this.futures.entrySet()) {
            CompletableFuture f = (CompletableFuture)entry.getValue();
            f.completeExceptionally((Throwable)new IOException());
        }
        if (previousState == ClientState.CONNECTED) {
            for (Map.Entry<String, ServerSubscription> entry : this.serverSubs.entrySet()) {
                this.listener.onSubscribing(this, new ServerSubscribingEvent(entry.getKey()));
            }
        }
        if (needEvent) {
            Object event;
            if (shouldReconnect.booleanValue()) {
                event = new ConnectingEvent(code, reason);
                this.listener.onConnecting(this, (ConnectingEvent)event);
            } else {
                event = new DisconnectedEvent(code, reason);
                this.listener.onDisconnected(this, (DisconnectedEvent)event);
            }
        }
        this.ws.cancel();
    }

    private void _connect() {
        Headers.Builder headers = new Headers.Builder();
        if (this.opts.getHeaders() != null) {
            for (Map.Entry<String, String> entry : this.opts.getHeaders().entrySet()) {
                headers.add(entry.getKey(), entry.getValue());
            }
        }
        Request request = new Request.Builder().url(this.endpoint).headers(headers.build()).addHeader("Sec-WebSocket-Protocol", "centrifuge-protobuf").build();
        if (this.ws != null) {
            this.ws.cancel();
        }
        OkHttpClient.Builder okHttpBuilder = new OkHttpClient.Builder();
        Dns dns = this.opts.getDns();
        if (dns != null) {
            okHttpBuilder.dns(dns::resolve);
        }
        if (this.opts.getProxy() != null) {
            okHttpBuilder.proxy(this.opts.getProxy());
            if (this.opts.getProxyLogin() != null && this.opts.getProxyPassword() != null) {
                okHttpBuilder.proxyAuthenticator((route, response) -> {
                    String credentials = Credentials.basic((String)this.opts.getProxyLogin(), (String)this.opts.getProxyPassword());
                    return response.request().newBuilder().header("Proxy-Authorization", credentials).build();
                });
            }
        }
        this.ws = okHttpBuilder.build().newWebSocket(request, new WebSocketListener(){

            public void onOpen(WebSocket webSocket, Response response) {
                super.onOpen(webSocket, response);
                Client.this.executor.submit(() -> {
                    try {
                        Client.this.handleConnectionOpen();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Client.this.processDisconnect(2, "bad protocol", false);
                    }
                });
            }

            public void onMessage(WebSocket webSocket, okio.ByteString bytes) {
                super.onMessage(webSocket, bytes);
                Client.this.executor.submit(() -> {
                    try {
                        Client.this.handleConnectionMessage(bytes.toByteArray());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Client.this.processDisconnect(2, "bad protocol", false);
                    }
                });
            }

            public void onClosing(WebSocket webSocket, int code, String reason) {
                super.onClosing(webSocket, code, reason);
                webSocket.close(1000, null);
            }

            public void onClosed(WebSocket webSocket, int code, String reason) {
                super.onClosed(webSocket, code, reason);
                Client.this.executor.submit(() -> {
                    boolean reconnect = code < 3500 || code >= 5000 || code >= 4000 && code < 4500;
                    int disconnectCode = code;
                    String disconnectReason = reason;
                    if (disconnectCode < 3000) {
                        if (disconnectCode == 1009) {
                            disconnectCode = 3;
                            disconnectReason = "message size limit";
                        } else {
                            disconnectCode = 1;
                            disconnectReason = "transport closed";
                        }
                    }
                    if (Client.this.getState() != ClientState.DISCONNECTED) {
                        Client.this.processDisconnect(disconnectCode, disconnectReason, reconnect);
                    }
                    if (Client.this.getState() == ClientState.CONNECTING) {
                        Client.this.scheduleReconnect();
                    }
                });
            }

            public void onFailure(WebSocket webSocket, Throwable t, Response response) {
                super.onFailure(webSocket, t, response);
                try {
                    Client.this.executor.submit(() -> {
                        Client.this.handleConnectionError(t);
                        Client.this.processDisconnect(1, "transport closed", true);
                        if (Client.this.getState() == ClientState.CONNECTING) {
                            Client.this.scheduleReconnect();
                        }
                    });
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    // empty catch block
                }
            }
        });
    }

    private void handleConnectionOpen() throws Exception {
        if (this.getState() != ClientState.CONNECTING) {
            return;
        }
        if (this.refreshRequired || this.token == null && this.opts.getTokenGetter() != null) {
            ConnectionTokenEvent connectionTokenEvent = new ConnectionTokenEvent();
            if (this.opts.getTokenGetter() == null) {
                throw new Exception("tokenGetter function should be provided in Client options to handle token refresh, see Options.setTokenGetter");
            }
            this.opts.getTokenGetter().getConnectionToken(connectionTokenEvent, (err, token) -> this.executor.submit(() -> {
                if (this.getState() != ClientState.CONNECTING) {
                    return;
                }
                if (err != null) {
                    this.listener.onError(this, new ErrorEvent(new TokenError(err)));
                    this.ws.close(1000, "");
                    return;
                }
                if (token.equals("")) {
                    this.failUnauthorized();
                    return;
                }
                this.token = token;
                this.refreshRequired = false;
                this.sendConnect();
            }));
        } else {
            this.sendConnect();
        }
    }

    private void handleConnectionMessage(byte[] bytes) {
        if (this.getState() != ClientState.CONNECTING && this.getState() != ClientState.CONNECTED) {
            return;
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        try {
            while (((InputStream)stream).available() > 0) {
                Protocol.Reply reply = Protocol.Reply.parseDelimitedFrom(stream);
                this.processReply(reply);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.processDisconnect(2, "bad protocol", false);
        }
    }

    private void handleConnectionError(Throwable t) {
        this.listener.onError(this, new ErrorEvent(t));
    }

    private void startReconnecting() {
        this.executor.submit(() -> {
            if (this.getState() != ClientState.CONNECTING) {
                return;
            }
            this._connect();
        });
    }

    private void scheduleReconnect() {
        if (this.getState() != ClientState.CONNECTING) {
            return;
        }
        this.reconnectTask = this.scheduler.schedule(this::startReconnecting, this.backoff.duration(this.reconnectAttempts, this.opts.getMinReconnectDelay(), this.opts.getMaxReconnectDelay()), TimeUnit.MILLISECONDS);
        ++this.reconnectAttempts;
    }

    private void sendSubscribeSynchronized(String channel, Protocol.SubscribeRequest req) {
        Protocol.Command cmd = (Protocol.Command)Protocol.Command.newBuilder().setId(this.getNextId()).setSubscribe(req).build();
        CompletableFuture f = new CompletableFuture();
        this.futures.put(cmd.getId(), (CompletableFuture<Protocol.Reply>)f);
        f.thenAccept(reply -> {
            if (this.getState() != ClientState.CONNECTED) {
                return;
            }
            this.handleSubscribeReply(channel, (Protocol.Reply)reply);
            this.futures.remove(cmd.getId());
        }).orTimeout((long)this.opts.getTimeout(), TimeUnit.MILLISECONDS).exceptionally(e -> {
            this.executor.submit(() -> {
                if (this.getState() != ClientState.CONNECTED) {
                    return;
                }
                this.futures.remove(cmd.getId());
                this.processDisconnect(3, "subscribe timeout", true);
            });
            return null;
        });
        this.ws.send(okio.ByteString.of((byte[])this.serializeCommand(cmd)));
    }

    void sendSubscribe(Subscription sub, Protocol.SubscribeRequest req) {
        if (this.getState() != ClientState.CONNECTED) {
            return;
        }
        this.sendSubscribeSynchronized(sub.getChannel(), req);
    }

    void sendUnsubscribe(String channel) {
        this.executor.submit(() -> this.sendUnsubscribeSynchronized(channel));
    }

    private void sendUnsubscribeSynchronized(String channel) {
        if (this.getState() != ClientState.CONNECTED) {
            return;
        }
        Protocol.UnsubscribeRequest req = (Protocol.UnsubscribeRequest)Protocol.UnsubscribeRequest.newBuilder().setChannel(channel).build();
        Protocol.Command cmd = (Protocol.Command)Protocol.Command.newBuilder().setId(this.getNextId()).setMethod(Protocol.Command.MethodType.UNSUBSCRIBE).setParams(req.toByteString()).build();
        CompletableFuture f = new CompletableFuture();
        this.futures.put(cmd.getId(), (CompletableFuture<Protocol.Reply>)f);
        f.thenAccept(reply -> this.futures.remove(cmd.getId())).orTimeout((long)this.opts.getTimeout(), TimeUnit.MILLISECONDS).exceptionally(e -> {
            this.futures.remove(cmd.getId());
            this.processDisconnect(4, "unsubscribe error", true);
            return null;
        });
        this.ws.send(okio.ByteString.of((byte[])this.serializeCommand(cmd)));
    }

    private byte[] serializeCommand(Protocol.Command cmd) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            cmd.writeDelimitedTo(stream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return stream.toByteArray();
    }

    private Subscription getSub(String channel) {
        return this.subs.get(channel);
    }

    private ServerSubscription getServerSub(String channel) {
        return this.serverSubs.get(channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Subscription newSubscription(String channel, SubscriptionEventListener listener) throws DuplicateSubscriptionException {
        Subscription sub;
        Map<String, Subscription> map = this.subs;
        synchronized (map) {
            if (this.subs.get(channel) != null) {
                throw new DuplicateSubscriptionException();
            }
            sub = new Subscription(this, channel, listener);
            this.subs.put(channel, sub);
        }
        return sub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Subscription getSubscription(String channel) {
        Subscription sub;
        Map<String, Subscription> map = this.subs;
        synchronized (map) {
            sub = this.getSub(channel);
        }
        return sub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubscription(Subscription sub) {
        Map<String, Subscription> map = this.subs;
        synchronized (map) {
            sub.unsubscribe();
            if (this.subs.get(sub.getChannel()) != null) {
                this.subs.remove(sub.getChannel());
            }
        }
    }

    private void handleSubscribeReply(String channel, Protocol.Reply reply) {
        Subscription sub = this.getSub(channel);
        if (sub != null) {
            if (reply.getError().getCode() != 0) {
                ReplyError err = new ReplyError(reply.getError().getCode(), reply.getError().getMessage(), reply.getError().getTemporary());
                sub.subscribeError(err);
                return;
            }
            Protocol.SubscribeResult result = reply.getSubscribe();
            sub.moveToSubscribed(result);
        }
    }

    private void _waitServerPing() {
        if (this.getState() != ClientState.CONNECTED) {
            return;
        }
        this.processDisconnect(2, "no ping", true);
    }

    private void waitServerPing() {
        this.executor.submit(this::_waitServerPing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleConnectReply(Protocol.Reply reply) {
        Protocol.Command cmd;
        if (this.getState() != ClientState.CONNECTING) {
            return;
        }
        if (reply.getError().getCode() != 0) {
            this.handleConnectionError(new ReplyError(reply.getError().getCode(), reply.getError().getMessage(), reply.getError().getTemporary()));
            if (reply.getError().getCode() == 109) {
                this.refreshRequired = true;
                this.ws.close(1000, "");
            } else if (reply.getError().getTemporary()) {
                this.ws.close(1000, "");
            } else {
                this.processDisconnect(reply.getError().getCode(), reply.getError().getMessage(), false);
            }
            return;
        }
        Protocol.ConnectResult result = reply.getConnect();
        ConnectedEvent event = new ConnectedEvent();
        event.setClient(result.getClient());
        event.setData(result.getData().toByteArray());
        this.setState(ClientState.CONNECTED);
        this.listener.onConnected(this, event);
        this.pingInterval = result.getPing() * 1000;
        this.sendPong = result.getPong();
        Map<String, Subscription> map = this.subs;
        synchronized (map) {
            for (Map.Entry<String, Subscription> entry : this.subs.entrySet()) {
                Subscription sub = entry.getValue();
                sub.resubscribeIfNecessary();
            }
        }
        for (Map.Entry entry : result.getSubsMap().entrySet()) {
            ServerSubscription serverSub;
            Protocol.SubscribeResult subscribeResult = (Protocol.SubscribeResult)entry.getValue();
            String channel = (String)entry.getKey();
            if (this.serverSubs.containsKey(channel)) {
                serverSub = this.serverSubs.get(channel);
            } else {
                serverSub = new ServerSubscription(subscribeResult.getRecoverable(), subscribeResult.getOffset(), subscribeResult.getEpoch());
                this.serverSubs.put(channel, serverSub);
            }
            serverSub.setRecoverable(subscribeResult.getRecoverable());
            serverSub.setLastEpoch(subscribeResult.getEpoch());
            byte[] data = null;
            if (subscribeResult.getData() != null) {
                data = subscribeResult.getData().toByteArray();
            }
            this.listener.onSubscribed(this, new ServerSubscribedEvent(channel, subscribeResult.getWasRecovering(), subscribeResult.getRecovered(), subscribeResult.getPositioned(), subscribeResult.getRecoverable(), subscribeResult.getPositioned() || subscribeResult.getRecoverable() ? new StreamPosition(subscribeResult.getOffset(), subscribeResult.getEpoch()) : null, data));
            if (subscribeResult.getPublicationsCount() > 0) {
                for (Protocol.Publication publication : subscribeResult.getPublicationsList()) {
                    ServerPublicationEvent publicationEvent = new ServerPublicationEvent();
                    publicationEvent.setChannel(channel);
                    publicationEvent.setData(publication.getData().toByteArray());
                    publicationEvent.setTags(publication.getTagsMap());
                    ClientInfo info = ClientInfo.fromProtocolClientInfo(publication.getInfo());
                    publicationEvent.setInfo(info);
                    publicationEvent.setOffset(publication.getOffset());
                    if (publication.getOffset() > 0L) {
                        serverSub.setLastOffset(publication.getOffset());
                    }
                    this.listener.onPublication(this, publicationEvent);
                }
                continue;
            }
            serverSub.setLastOffset(subscribeResult.getOffset());
        }
        Iterator<Map.Entry<String, ServerSubscription>> it = this.serverSubs.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, ServerSubscription> entry = it.next();
            if (result.getSubsMap().containsKey(entry.getKey())) continue;
            this.listener.onUnsubscribed(this, new ServerUnsubscribedEvent(entry.getKey()));
            it.remove();
        }
        this.reconnectAttempts = 0;
        for (Map.Entry<Integer, Protocol.Command> entry : this.connectCommands.entrySet()) {
            CompletableFuture<Protocol.Reply> f;
            cmd = entry.getValue();
            boolean sent = this.ws.send(okio.ByteString.of((byte[])this.serializeCommand(cmd)));
            if (sent || (f = this.futures.get(cmd.getId())) == null) continue;
            f.completeExceptionally((Throwable)new IOException());
        }
        this.connectCommands.clear();
        for (Map.Entry<Integer, Protocol.Command> entry : this.connectAsyncCommands.entrySet()) {
            cmd = entry.getValue();
            CompletableFuture<Protocol.Reply> f = this.futures.get(cmd.getId());
            boolean sent = this.ws.send(okio.ByteString.of((byte[])this.serializeCommand(cmd)));
            if (!sent) {
                if (f == null) continue;
                f.completeExceptionally((Throwable)new IOException());
                continue;
            }
            if (f == null) continue;
            f.complete(null);
        }
        this.connectAsyncCommands.clear();
        this.pingTask = this.scheduler.schedule(this::waitServerPing, (long)(this.pingInterval + this.opts.getMaxServerPingDelay()), TimeUnit.MILLISECONDS);
        if (result.getExpires()) {
            int n = result.getTtl();
            this.refreshTask = this.scheduler.schedule(this::sendRefresh, (long)n, TimeUnit.SECONDS);
        }
    }

    private void sendRefresh() {
        if (this.opts.getTokenGetter() == null) {
            return;
        }
        this.executor.submit(() -> this.opts.getTokenGetter().getConnectionToken(new ConnectionTokenEvent(), (err, token) -> this.executor.submit(() -> {
            if (this.getState() != ClientState.CONNECTED) {
                return;
            }
            if (err != null) {
                this.listener.onError(this, new ErrorEvent(new TokenError(err)));
                this.refreshTask = this.scheduler.schedule(this::sendRefresh, this.backoff.duration(0, 10000, 20000), TimeUnit.MILLISECONDS);
                return;
            }
            if (token.equals("")) {
                this.failUnauthorized();
                return;
            }
            this.token = token;
            this.refreshSynchronized(token, (error, result) -> {
                if (this.getState() != ClientState.CONNECTED) {
                    return;
                }
                if (error != null) {
                    this.listener.onError(this, new ErrorEvent(new RefreshError(error)));
                    if (error instanceof ReplyError) {
                        ReplyError e = (ReplyError)error;
                        if (e.isTemporary()) {
                            this.refreshTask = this.scheduler.schedule(this::sendRefresh, this.backoff.duration(0, 10000, 20000), TimeUnit.MILLISECONDS);
                        } else {
                            this.processDisconnect(e.getCode(), e.getMessage(), false);
                        }
                        return;
                    }
                    this.refreshTask = this.scheduler.schedule(this::sendRefresh, this.backoff.duration(0, 10000, 20000), TimeUnit.MILLISECONDS);
                    return;
                }
                if (result.getExpires()) {
                    int ttl = result.getTtl();
                    this.refreshTask = this.scheduler.schedule(this::sendRefresh, (long)ttl, TimeUnit.SECONDS);
                }
            });
        })));
    }

    private void sendConnect() {
        Protocol.ConnectRequest.Builder build = Protocol.ConnectRequest.newBuilder();
        if (this.token.length() > 0) {
            build.setToken(this.token);
        }
        if (this.opts.getName().length() > 0) {
            build.setName(this.opts.getName());
        }
        if (this.opts.getVersion().length() > 0) {
            build.setVersion(this.opts.getVersion());
        }
        if (this.data != null) {
            build.setData(this.data);
        }
        if (this.serverSubs.size() > 0) {
            for (Map.Entry<String, ServerSubscription> entry : this.serverSubs.entrySet()) {
                Protocol.SubscribeRequest.Builder subReqBuild = Protocol.SubscribeRequest.newBuilder();
                if (entry.getValue().getRecoverable()) {
                    subReqBuild.setEpoch(entry.getValue().getEpoch());
                    subReqBuild.setOffset(entry.getValue().getOffset());
                    subReqBuild.setRecover(true);
                }
                build.putSubs(entry.getKey(), (Protocol.SubscribeRequest)subReqBuild.build());
            }
        }
        Protocol.ConnectRequest req = (Protocol.ConnectRequest)build.build();
        Protocol.Command cmd = (Protocol.Command)Protocol.Command.newBuilder().setId(this.getNextId()).setConnect(req).build();
        CompletableFuture f = new CompletableFuture();
        this.futures.put(cmd.getId(), (CompletableFuture<Protocol.Reply>)f);
        f.thenAccept(reply -> {
            this.futures.remove(cmd.getId());
            try {
                this.handleConnectReply((Protocol.Reply)reply);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }).orTimeout((long)this.opts.getTimeout(), TimeUnit.MILLISECONDS).exceptionally(e -> {
            this.handleConnectionError((Throwable)e);
            this.futures.remove(cmd.getId());
            this.ws.close(1000, "");
            return null;
        });
        this.ws.send(okio.ByteString.of((byte[])this.serializeCommand(cmd)));
    }

    private void failUnauthorized() {
        this.processDisconnect(1, "unauthorized", false);
    }

    private void processReply(Protocol.Reply reply) {
        if (reply.getId() > 0) {
            CompletableFuture<Protocol.Reply> cf = this.futures.get(reply.getId());
            if (cf != null) {
                cf.complete((Object)reply);
            }
        } else if (reply.hasPush()) {
            this.handlePush(reply.getPush());
        } else {
            this.handlePing();
        }
    }

    private void handlePub(String channel, Protocol.Publication pub) {
        ClientInfo info = ClientInfo.fromProtocolClientInfo(pub.getInfo());
        Subscription sub = this.getSub(channel);
        if (sub != null) {
            PublicationEvent event = new PublicationEvent();
            event.setData(pub.getData().toByteArray());
            event.setInfo(info);
            event.setOffset(pub.getOffset());
            event.setTags(pub.getTagsMap());
            if (pub.getOffset() > 0L) {
                sub.setOffset(pub.getOffset());
            }
            sub.getListener().onPublication(sub, event);
        } else {
            ServerSubscription serverSub = this.getServerSub(channel);
            if (serverSub != null) {
                ServerPublicationEvent event = new ServerPublicationEvent();
                event.setChannel(channel);
                event.setData(pub.getData().toByteArray());
                event.setInfo(info);
                event.setOffset(pub.getOffset());
                event.setTags(pub.getTagsMap());
                if (pub.getOffset() > 0L) {
                    serverSub.setLastOffset(pub.getOffset());
                }
                this.listener.onPublication(this, event);
            }
        }
    }

    private void handleSubscribe(String channel, Protocol.Subscribe sub) {
        ServerSubscription serverSub = new ServerSubscription(sub.getRecoverable(), sub.getOffset(), sub.getEpoch());
        this.serverSubs.put(channel, serverSub);
        serverSub.setRecoverable(sub.getRecoverable());
        serverSub.setLastEpoch(sub.getEpoch());
        serverSub.setLastOffset(sub.getOffset());
        byte[] data = null;
        if (sub.getData() != null) {
            data = sub.getData().toByteArray();
        }
        this.listener.onSubscribed(this, new ServerSubscribedEvent(channel, false, false, sub.getPositioned(), sub.getRecoverable(), sub.getPositioned() || sub.getRecoverable() ? new StreamPosition(sub.getOffset(), sub.getEpoch()) : null, data));
    }

    private void handleUnsubscribe(String channel, Protocol.Unsubscribe unsubscribe) {
        Subscription sub = this.getSub(channel);
        if (sub != null) {
            if (unsubscribe.getCode() < 2500) {
                sub.moveToUnsubscribed(false, unsubscribe.getCode(), unsubscribe.getReason());
            } else {
                sub.moveToSubscribing(unsubscribe.getCode(), unsubscribe.getReason());
                sub.resubscribeIfNecessary();
            }
        } else {
            ServerSubscription serverSub = this.getServerSub(channel);
            if (serverSub != null) {
                this.serverSubs.remove(channel);
                this.listener.onUnsubscribed(this, new ServerUnsubscribedEvent(channel));
            }
        }
    }

    private void handleJoin(String channel, Protocol.Join join) {
        ClientInfo info = ClientInfo.fromProtocolClientInfo(join.getInfo());
        Subscription sub = this.getSub(channel);
        if (sub != null) {
            JoinEvent event = new JoinEvent();
            event.setInfo(info);
            sub.getListener().onJoin(sub, event);
        } else {
            ServerSubscription serverSub = this.getServerSub(channel);
            if (serverSub != null) {
                this.listener.onJoin(this, new ServerJoinEvent(channel, info));
            }
        }
    }

    private void handleLeave(String channel, Protocol.Leave leave) {
        LeaveEvent event = new LeaveEvent();
        ClientInfo info = ClientInfo.fromProtocolClientInfo(leave.getInfo());
        Subscription sub = this.getSub(channel);
        if (sub != null) {
            event.setInfo(info);
            sub.getListener().onLeave(sub, event);
        } else {
            ServerSubscription serverSub = this.getServerSub(channel);
            if (serverSub != null) {
                this.listener.onLeave(this, new ServerLeaveEvent(channel, info));
            }
        }
    }

    private void handleMessage(Protocol.Message msg) {
        MessageEvent event = new MessageEvent();
        event.setData(msg.getData().toByteArray());
        this.listener.onMessage(this, event);
    }

    private void handlePush(Protocol.Push push) {
        String channel = push.getChannel();
        if (push.hasPub()) {
            this.handlePub(channel, push.getPub());
        } else if (push.hasSubscribe()) {
            this.handleSubscribe(channel, push.getSubscribe());
        } else if (push.hasJoin()) {
            this.handleJoin(channel, push.getJoin());
        } else if (push.hasLeave()) {
            this.handleLeave(channel, push.getLeave());
        } else if (push.hasUnsubscribe()) {
            this.handleUnsubscribe(channel, push.getUnsubscribe());
        } else if (push.hasMessage()) {
            this.handleMessage(push.getMessage());
        }
    }

    private void handlePing() {
        if (this.pingTask != null) {
            this.pingTask.cancel(true);
        }
        this.pingTask = this.scheduler.schedule(this::waitServerPing, (long)(this.pingInterval + this.opts.getMaxServerPingDelay()), TimeUnit.MILLISECONDS);
        if (this.sendPong) {
            Protocol.Command cmd = (Protocol.Command)Protocol.Command.newBuilder().build();
            this.ws.send(okio.ByteString.of((byte[])this.serializeCommand(cmd)));
        }
    }

    public void send(byte[] data, CompletionCallback cb) {
        this.executor.submit(() -> this.sendSynchronized(data, cb));
    }

    private void sendSynchronized(byte[] data, CompletionCallback cb) {
        Protocol.SendRequest req = (Protocol.SendRequest)Protocol.SendRequest.newBuilder().setData(ByteString.copyFrom((byte[])data)).build();
        Protocol.Command cmd = (Protocol.Command)Protocol.Command.newBuilder().setId(this.getNextId()).setSend(req).build();
        CompletableFuture f = new CompletableFuture();
        this.futures.put(cmd.getId(), (CompletableFuture<Protocol.Reply>)f);
        f.thenAccept(reply -> {
            this.cleanCommandFuture(cmd);
            cb.onDone(null);
        }).orTimeout((long)this.opts.getTimeout(), TimeUnit.MILLISECONDS).exceptionally(e -> {
            this.executor.submit(() -> {
                this.cleanCommandFuture(cmd);
                cb.onDone((Throwable)e);
            });
            return null;
        });
        if (this.getState() != ClientState.CONNECTED) {
            this.connectAsyncCommands.put(cmd.getId(), cmd);
        } else {
            boolean sent = this.ws.send(okio.ByteString.of((byte[])this.serializeCommand(cmd)));
            if (!sent) {
                f.completeExceptionally((Throwable)new IOException());
            } else {
                f.complete(null);
            }
        }
    }

    private void enqueueCommandFuture(Protocol.Command cmd, CompletableFuture<Protocol.Reply> f) {
        this.futures.put(cmd.getId(), f);
        if (this.getState() != ClientState.CONNECTED) {
            this.connectCommands.put(cmd.getId(), cmd);
        } else {
            boolean sent = this.ws.send(okio.ByteString.of((byte[])this.serializeCommand(cmd)));
            if (!sent) {
                f.completeExceptionally((Throwable)new IOException());
            }
        }
    }

    ReplyError getReplyError(Protocol.Reply reply) {
        return new ReplyError(reply.getError().getCode(), reply.getError().getMessage(), reply.getError().getTemporary());
    }

    private void cleanCommandFuture(Protocol.Command cmd) {
        this.futures.remove(cmd.getId());
        if (this.connectCommands.get(cmd.getId()) != null) {
            this.connectCommands.remove(cmd.getId());
        }
        if (this.connectAsyncCommands.get(cmd.getId()) != null) {
            this.connectAsyncCommands.remove(cmd.getId());
        }
    }

    public void rpc(String method, byte[] data, ResultCallback<RPCResult> cb) {
        this.executor.submit(() -> this.rpcSynchronized(method, data, cb));
    }

    private void rpcSynchronized(String method, byte[] data, ResultCallback<RPCResult> cb) {
        Protocol.RPCRequest.Builder builder = Protocol.RPCRequest.newBuilder().setData(ByteString.copyFrom((byte[])data));
        if (method != null) {
            builder.setMethod(method);
        }
        Protocol.RPCRequest req = (Protocol.RPCRequest)builder.build();
        Protocol.Command cmd = (Protocol.Command)Protocol.Command.newBuilder().setId(this.getNextId()).setRpc(req).build();
        CompletableFuture f = new CompletableFuture();
        f.thenAccept(reply -> {
            this.cleanCommandFuture(cmd);
            if (reply.getError().getCode() != 0) {
                cb.onDone(this.getReplyError((Protocol.Reply)reply), null);
            } else {
                Protocol.RPCResult rpcResult = reply.getRpc();
                RPCResult result = new RPCResult();
                result.setData(rpcResult.getData().toByteArray());
                cb.onDone(null, result);
            }
        }).orTimeout((long)this.opts.getTimeout(), TimeUnit.MILLISECONDS).exceptionally(e -> {
            this.executor.submit(() -> {
                this.cleanCommandFuture(cmd);
                cb.onDone((Throwable)e, (RPCResult)null);
            });
            return null;
        });
        this.enqueueCommandFuture(cmd, (CompletableFuture<Protocol.Reply>)f);
    }

    public void publish(String channel, byte[] data, ResultCallback<PublishResult> cb) {
        this.executor.submit(() -> this.publishSynchronized(channel, data, cb));
    }

    private void publishSynchronized(String channel, byte[] data, ResultCallback<PublishResult> cb) {
        Protocol.PublishRequest req = (Protocol.PublishRequest)Protocol.PublishRequest.newBuilder().setChannel(channel).setData(ByteString.copyFrom((byte[])data)).build();
        Protocol.Command cmd = (Protocol.Command)Protocol.Command.newBuilder().setId(this.getNextId()).setPublish(req).build();
        CompletableFuture f = new CompletableFuture();
        f.thenAccept(reply -> {
            this.cleanCommandFuture(cmd);
            if (reply.getError().getCode() != 0) {
                cb.onDone(this.getReplyError((Protocol.Reply)reply), null);
            } else {
                PublishResult result = new PublishResult();
                cb.onDone(null, result);
            }
        }).orTimeout((long)this.opts.getTimeout(), TimeUnit.MILLISECONDS).exceptionally(e -> {
            this.executor.submit(() -> {
                this.cleanCommandFuture(cmd);
                cb.onDone((Throwable)e, (PublishResult)null);
            });
            return null;
        });
        this.enqueueCommandFuture(cmd, (CompletableFuture<Protocol.Reply>)f);
    }

    public void history(String channel, HistoryOptions opts, ResultCallback<HistoryResult> cb) {
        this.executor.submit(() -> this.historySynchronized(channel, opts, cb));
    }

    private void historySynchronized(String channel, HistoryOptions opts, ResultCallback<HistoryResult> cb) {
        Protocol.HistoryRequest.Builder builder = Protocol.HistoryRequest.newBuilder().setChannel(channel).setReverse(opts.getReverse()).setLimit(opts.getLimit());
        if (opts.getSince() != null) {
            builder.setSince(opts.getSince().toProto());
        }
        Protocol.HistoryRequest req = (Protocol.HistoryRequest)builder.build();
        Protocol.Command cmd = (Protocol.Command)Protocol.Command.newBuilder().setId(this.getNextId()).setHistory(req).build();
        CompletableFuture f = new CompletableFuture();
        f.thenAccept(reply -> {
            this.cleanCommandFuture(cmd);
            if (reply.getError().getCode() != 0) {
                cb.onDone(this.getReplyError((Protocol.Reply)reply), null);
            } else {
                Protocol.HistoryResult replyResult = reply.getHistory();
                HistoryResult result = new HistoryResult();
                List<Protocol.Publication> protoPubs = replyResult.getPublicationsList();
                ArrayList<Publication> pubs = new ArrayList<Publication>();
                for (int i = 0; i < protoPubs.size(); ++i) {
                    Protocol.Publication protoPub = protoPubs.get(i);
                    Publication pub = new Publication();
                    pub.setData(protoPub.getData().toByteArray());
                    pub.setOffset(protoPub.getOffset());
                    pubs.add(pub);
                }
                result.setPublications(pubs);
                result.setOffset(replyResult.getOffset());
                result.setEpoch(replyResult.getEpoch());
                cb.onDone(null, result);
            }
        }).orTimeout((long)this.opts.getTimeout(), TimeUnit.MILLISECONDS).exceptionally(e -> {
            this.executor.submit(() -> {
                this.cleanCommandFuture(cmd);
                cb.onDone((Throwable)e, (HistoryResult)null);
            });
            return null;
        });
        this.enqueueCommandFuture(cmd, (CompletableFuture<Protocol.Reply>)f);
    }

    public void presence(String channel, ResultCallback<PresenceResult> cb) {
        this.executor.submit(() -> this.presenceSynchronized(channel, cb));
    }

    private void presenceSynchronized(String channel, ResultCallback<PresenceResult> cb) {
        Protocol.PresenceRequest req = (Protocol.PresenceRequest)Protocol.PresenceRequest.newBuilder().setChannel(channel).build();
        Protocol.Command cmd = (Protocol.Command)Protocol.Command.newBuilder().setId(this.getNextId()).setPresence(req).build();
        CompletableFuture f = new CompletableFuture();
        f.thenAccept(reply -> {
            this.cleanCommandFuture(cmd);
            if (reply.getError().getCode() != 0) {
                cb.onDone(this.getReplyError((Protocol.Reply)reply), null);
            } else {
                Protocol.PresenceResult replyResult = reply.getPresence();
                Map<String, Protocol.ClientInfo> protoPresence = replyResult.getPresenceMap();
                HashMap<String, ClientInfo> presence = new HashMap<String, ClientInfo>();
                for (Map.Entry<String, Protocol.ClientInfo> entry : protoPresence.entrySet()) {
                    Protocol.ClientInfo protoClientInfo = entry.getValue();
                    presence.put(entry.getKey(), ClientInfo.fromProtocolClientInfo(protoClientInfo));
                }
                PresenceResult result = new PresenceResult(presence);
                cb.onDone(null, result);
            }
        }).orTimeout((long)this.opts.getTimeout(), TimeUnit.MILLISECONDS).exceptionally(e -> {
            this.executor.submit(() -> {
                this.cleanCommandFuture(cmd);
                cb.onDone((Throwable)e, (PresenceResult)null);
            });
            return null;
        });
        this.enqueueCommandFuture(cmd, (CompletableFuture<Protocol.Reply>)f);
    }

    public void presenceStats(String channel, ResultCallback<PresenceStatsResult> cb) {
        this.executor.submit(() -> this.presenceStatsSynchronized(channel, cb));
    }

    private void presenceStatsSynchronized(String channel, ResultCallback<PresenceStatsResult> cb) {
        Protocol.PresenceStatsRequest req = (Protocol.PresenceStatsRequest)Protocol.PresenceStatsRequest.newBuilder().setChannel(channel).build();
        Protocol.Command cmd = (Protocol.Command)Protocol.Command.newBuilder().setId(this.getNextId()).setPresenceStats(req).build();
        CompletableFuture f = new CompletableFuture();
        f.thenAccept(reply -> {
            this.cleanCommandFuture(cmd);
            if (reply.getError().getCode() != 0) {
                cb.onDone(this.getReplyError((Protocol.Reply)reply), null);
            } else {
                Protocol.PresenceStatsResult replyResult = reply.getPresenceStats();
                PresenceStatsResult result = new PresenceStatsResult();
                result.setNumClients(replyResult.getNumClients());
                result.setNumUsers(replyResult.getNumUsers());
                cb.onDone(null, result);
            }
        }).orTimeout((long)this.opts.getTimeout(), TimeUnit.MILLISECONDS).exceptionally(e -> {
            this.executor.submit(() -> {
                this.cleanCommandFuture(cmd);
                cb.onDone((Throwable)e, (PresenceStatsResult)null);
            });
            return null;
        });
        this.enqueueCommandFuture(cmd, (CompletableFuture<Protocol.Reply>)f);
    }

    private void refreshSynchronized(String token, ResultCallback<Protocol.RefreshResult> cb) {
        Protocol.RefreshRequest req = (Protocol.RefreshRequest)Protocol.RefreshRequest.newBuilder().setToken(token).build();
        Protocol.Command cmd = (Protocol.Command)Protocol.Command.newBuilder().setId(this.getNextId()).setRefresh(req).build();
        CompletableFuture f = new CompletableFuture();
        f.thenAccept(reply -> {
            this.cleanCommandFuture(cmd);
            if (reply.getError().getCode() != 0) {
                cb.onDone(this.getReplyError((Protocol.Reply)reply), null);
            } else {
                Protocol.RefreshResult replyResult = reply.getRefresh();
                cb.onDone(null, replyResult);
            }
        }).orTimeout((long)this.opts.getTimeout(), TimeUnit.MILLISECONDS).exceptionally(e -> {
            this.executor.submit(() -> {
                this.cleanCommandFuture(cmd);
                cb.onDone((Throwable)e, (Protocol.RefreshResult)null);
            });
            return null;
        });
        this.enqueueCommandFuture(cmd, (CompletableFuture<Protocol.Reply>)f);
    }

    void subRefreshSynchronized(String channel, String token, ResultCallback<Protocol.SubRefreshResult> cb) {
        Protocol.SubRefreshRequest req = (Protocol.SubRefreshRequest)Protocol.SubRefreshRequest.newBuilder().setToken(token).setChannel(channel).build();
        Protocol.Command cmd = (Protocol.Command)Protocol.Command.newBuilder().setId(this.getNextId()).setSubRefresh(req).build();
        CompletableFuture f = new CompletableFuture();
        f.thenAccept(reply -> {
            this.cleanCommandFuture(cmd);
            if (reply.getError().getCode() != 0) {
                cb.onDone(this.getReplyError((Protocol.Reply)reply), null);
            } else {
                Protocol.SubRefreshResult replyResult = reply.getSubRefresh();
                cb.onDone(null, replyResult);
            }
        }).orTimeout((long)this.opts.getTimeout(), TimeUnit.MILLISECONDS).exceptionally(e -> {
            this.executor.submit(() -> {
                this.cleanCommandFuture(cmd);
                cb.onDone((Throwable)e, (Protocol.SubRefreshResult)null);
            });
            return null;
        });
        this.enqueueCommandFuture(cmd, (CompletableFuture<Protocol.Reply>)f);
    }
}

