/*
 * Decompiled with CFR 0.152.
 */
package io.github.centrifugal.centrifuge;

import com.google.protobuf.ByteString;
import io.github.centrifugal.centrifuge.Client;
import io.github.centrifugal.centrifuge.ClientInfo;
import io.github.centrifugal.centrifuge.Fossil;
import io.github.centrifugal.centrifuge.HistoryOptions;
import io.github.centrifugal.centrifuge.HistoryResult;
import io.github.centrifugal.centrifuge.PresenceResult;
import io.github.centrifugal.centrifuge.PresenceStatsResult;
import io.github.centrifugal.centrifuge.PublicationEvent;
import io.github.centrifugal.centrifuge.PublishResult;
import io.github.centrifugal.centrifuge.ReplyError;
import io.github.centrifugal.centrifuge.ResultCallback;
import io.github.centrifugal.centrifuge.StreamPosition;
import io.github.centrifugal.centrifuge.SubscribedEvent;
import io.github.centrifugal.centrifuge.SubscribingEvent;
import io.github.centrifugal.centrifuge.SubscriptionErrorEvent;
import io.github.centrifugal.centrifuge.SubscriptionEventListener;
import io.github.centrifugal.centrifuge.SubscriptionOptions;
import io.github.centrifugal.centrifuge.SubscriptionRefreshError;
import io.github.centrifugal.centrifuge.SubscriptionState;
import io.github.centrifugal.centrifuge.SubscriptionStateError;
import io.github.centrifugal.centrifuge.SubscriptionSubscribeError;
import io.github.centrifugal.centrifuge.SubscriptionTokenError;
import io.github.centrifugal.centrifuge.SubscriptionTokenEvent;
import io.github.centrifugal.centrifuge.UnauthorizedException;
import io.github.centrifugal.centrifuge.UnsubscribedEvent;
import io.github.centrifugal.centrifuge.internal.backoff.Backoff;
import io.github.centrifugal.centrifuge.internal.protocol.Protocol;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java8.util.concurrent.CompletableFuture;

public class Subscription {
    private final Client client;
    private final String channel;
    private final SubscriptionOptions opts;
    private boolean recover;
    private long offset;
    private String epoch;
    private final SubscriptionEventListener listener;
    private volatile SubscriptionState state = SubscriptionState.UNSUBSCRIBED;
    private final Map<String, CompletableFuture<Throwable>> futures = new ConcurrentHashMap<String, CompletableFuture<Throwable>>();
    private final Backoff backoff;
    private ScheduledFuture<?> refreshTask;
    private ScheduledFuture<?> resubscribeTask;
    private int resubscribeAttempts = 0;
    private String token;
    private ByteString data;
    private boolean deltaNegotiated;
    private byte[] prevData;

    Subscription(Client client, String channel, SubscriptionEventListener listener, SubscriptionOptions options) {
        this.client = client;
        this.channel = channel;
        this.listener = listener;
        this.backoff = new Backoff();
        this.opts = options;
        this.token = this.opts.getToken();
        if (this.opts.getData() != null) {
            this.data = ByteString.copyFrom((byte[])this.opts.getData());
        }
        this.prevData = null;
        this.deltaNegotiated = false;
        if (this.opts.getSince() != null) {
            this.offset = this.opts.getSince().getOffset();
            this.epoch = this.opts.getSince().getEpoch();
            this.recover = true;
        }
    }

    Subscription(Client client, String channel, SubscriptionEventListener listener) {
        this(client, channel, listener, new SubscriptionOptions());
    }

    void setState(SubscriptionState state) {
        this.state = state;
    }

    public SubscriptionState getState() {
        return this.state;
    }

    public String getChannel() {
        return this.channel;
    }

    SubscriptionEventListener getListener() {
        return this.listener;
    }

    long getOffset() {
        return this.offset;
    }

    private void setOffset(long offset) {
        this.offset = offset;
    }

    String getEpoch() {
        return this.epoch;
    }

    private void setEpoch(String epoch) {
        this.epoch = epoch;
    }

    void resubscribeIfNecessary() {
        if (this.getState() != SubscriptionState.SUBSCRIBING) {
            return;
        }
        this.sendSubscribe();
    }

    void sendRefresh() {
        if (this.opts.getTokenGetter() == null) {
            return;
        }
        this.client.getExecutor().submit(() -> this.opts.getTokenGetter().getSubscriptionToken(new SubscriptionTokenEvent(this.getChannel()), (err, token) -> {
            if (this.getState() != SubscriptionState.SUBSCRIBED) {
                return;
            }
            if (err != null) {
                if (err instanceof UnauthorizedException) {
                    this.failUnauthorized(true);
                    return;
                }
                this.listener.onError(this, new SubscriptionErrorEvent(new SubscriptionTokenError(err)));
                this.refreshTask = this.client.getScheduler().schedule(this::sendRefresh, this.backoff.duration(0, 10000, 20000), TimeUnit.MILLISECONDS);
                return;
            }
            if (token == null || token.equals("")) {
                this.failUnauthorized(true);
                return;
            }
            this.token = token;
            this.client.subRefreshSynchronized(this.channel, token, (error, result) -> {
                Throwable errorOrNull;
                if (this.getState() != SubscriptionState.SUBSCRIBED) {
                    return;
                }
                Throwable throwable = error != null ? error : (errorOrNull = result == null ? new NullPointerException() : null);
                if (errorOrNull != null) {
                    this.listener.onError(this, new SubscriptionErrorEvent(new SubscriptionRefreshError(errorOrNull)));
                    if (error instanceof ReplyError) {
                        ReplyError e = (ReplyError)error;
                        if (e.isTemporary()) {
                            this.refreshTask = this.client.getScheduler().schedule(this::sendRefresh, this.backoff.duration(0, 10000, 20000), TimeUnit.MILLISECONDS);
                        } else {
                            this._unsubscribe(true, e.getCode(), e.getMessage());
                        }
                        return;
                    }
                    this.refreshTask = this.client.getScheduler().schedule(this::sendRefresh, this.backoff.duration(0, 10000, 20000), TimeUnit.MILLISECONDS);
                    return;
                }
                if (result.getExpires()) {
                    this.refreshTask = this.client.getScheduler().schedule(this::sendRefresh, (long)result.getTtl(), TimeUnit.SECONDS);
                }
            });
        }));
    }

    void moveToSubscribing(int code, String reason) {
        if (this.getState() == SubscriptionState.SUBSCRIBING) {
            this.clearSubscribingState();
            return;
        }
        this.setState(SubscriptionState.SUBSCRIBING);
        this.listener.onSubscribing(this, new SubscribingEvent(code, reason));
    }

    void moveToUnsubscribed(boolean sendUnsubscribe, int code, String reason) {
        if (this.getState() == SubscriptionState.UNSUBSCRIBED) {
            return;
        }
        this._unsubscribe(sendUnsubscribe, code, reason);
    }

    void handlePublication(Protocol.Publication pub) throws Exception {
        ClientInfo info = ClientInfo.fromProtocolClientInfo(pub.getInfo());
        PublicationEvent event = new PublicationEvent();
        byte[] pubData = pub.getData().toByteArray();
        if (this.deltaNegotiated) {
            byte[] prevData = this.getPrevData();
            if (prevData != null && pub.getDelta()) {
                pubData = Fossil.applyDelta(prevData, pubData);
            }
            this.setPrevData(pubData);
        }
        event.setData(pubData);
        event.setInfo(info);
        event.setOffset(pub.getOffset());
        event.setTags(pub.getTagsMap());
        if (pub.getOffset() > 0L) {
            this.setOffset(pub.getOffset());
        }
        this.listener.onPublication(this, event);
    }

    void moveToSubscribed(Protocol.SubscribeResult result) throws Exception {
        this.setState(SubscriptionState.SUBSCRIBED);
        if (result.getRecoverable()) {
            this.recover = true;
        }
        this.setEpoch(result.getEpoch());
        this.deltaNegotiated = result.getDelta();
        byte[] data = null;
        if (result.getData() != null) {
            data = result.getData().toByteArray();
        }
        SubscribedEvent event = new SubscribedEvent(result.getWasRecovering(), result.getRecovered(), result.getPositioned(), result.getRecoverable(), result.getPositioned() || result.getRecoverable() ? new StreamPosition(result.getOffset(), result.getEpoch()) : null, data);
        this.listener.onSubscribed(this, event);
        if (result.getPublicationsCount() > 0) {
            for (Protocol.Publication publication : result.getPublicationsList()) {
                this.client.handlePub(this.channel, publication);
            }
        } else {
            this.setOffset(result.getOffset());
        }
        for (Map.Entry entry : this.futures.entrySet()) {
            CompletableFuture f = (CompletableFuture)entry.getValue();
            f.complete(null);
        }
        this.futures.clear();
        if (result.getExpires()) {
            this.refreshTask = this.client.getScheduler().schedule(this::sendRefresh, (long)result.getTtl(), TimeUnit.SECONDS);
        }
    }

    void subscribeError(ReplyError err) {
        this.listener.onError(this, new SubscriptionErrorEvent(new SubscriptionSubscribeError(err)));
        if (err.getCode() == 109) {
            this.token = "";
            this.scheduleResubscribe();
        }
        if (err.isTemporary()) {
            this.scheduleResubscribe();
        } else {
            this._unsubscribe(false, err.getCode(), err.getMessage());
        }
    }

    public void subscribe() {
        this.client.getExecutor().submit(() -> {
            if (this.getState() == SubscriptionState.SUBSCRIBED || this.getState() == SubscriptionState.SUBSCRIBING) {
                return;
            }
            this.setState(SubscriptionState.SUBSCRIBING);
            this.listener.onSubscribing(this, new SubscribingEvent(0, "subscribe called"));
            this.sendSubscribe();
        });
    }

    Protocol.SubscribeRequest createSubscribeRequest() {
        boolean isRecover = this.getRecover();
        StreamPosition streamPosition = new StreamPosition();
        if (isRecover) {
            streamPosition.setOffset(this.getOffset());
            streamPosition.setEpoch(this.getEpoch());
        }
        Protocol.SubscribeRequest.Builder builder = Protocol.SubscribeRequest.newBuilder();
        builder.setChannel(this.channel).setToken(this.token);
        if (this.data != null) {
            builder.setData(this.data);
        }
        if (isRecover) {
            builder.setRecover(true).setEpoch(streamPosition.getEpoch()).setOffset(streamPosition.getOffset());
        }
        builder.setPositioned(this.opts.isPositioned());
        builder.setRecoverable(this.opts.isRecoverable());
        builder.setJoinLeave(this.opts.isJoinLeave());
        builder.setDelta(this.opts.getDelta());
        return (Protocol.SubscribeRequest)builder.build();
    }

    void sendSubscribe() {
        boolean isRecover = this.getRecover();
        StreamPosition streamPosition = new StreamPosition();
        if (isRecover) {
            streamPosition.setOffset(this.getOffset());
            streamPosition.setEpoch(this.getEpoch());
        }
        if (this.token.equals("") && this.opts.getTokenGetter() != null) {
            SubscriptionTokenEvent subscriptionTokenEvent = new SubscriptionTokenEvent(this.channel);
            this.opts.getTokenGetter().getSubscriptionToken(subscriptionTokenEvent, (err, token) -> this.client.getExecutor().submit(() -> {
                if (this.getState() != SubscriptionState.SUBSCRIBING) {
                    return;
                }
                if (err != null) {
                    if (err instanceof UnauthorizedException) {
                        this.failUnauthorized(true);
                        return;
                    }
                    this.listener.onError(this, new SubscriptionErrorEvent(new SubscriptionTokenError(err)));
                    this.scheduleResubscribe();
                    return;
                }
                if (token == null || token.equals("")) {
                    this.failUnauthorized(false);
                    return;
                }
                this.token = token;
                this.client.sendSubscribe(this, this.createSubscribeRequest());
            }));
        } else {
            this.client.sendSubscribe(this, this.createSubscribeRequest());
        }
    }

    public void unsubscribe() {
        this.client.getExecutor().submit(() -> this._unsubscribe(true, 0, "unsubscribe called"));
    }

    private void clearSubscribedState() {
        if (this.refreshTask != null) {
            this.refreshTask.cancel(true);
            this.refreshTask = null;
        }
    }

    private void clearSubscribingState() {
        if (this.resubscribeTask != null) {
            this.resubscribeTask.cancel(true);
            this.resubscribeTask = null;
        }
    }

    private void _unsubscribe(boolean sendUnsubscribe, int code, String reason) {
        if (this.getState() == SubscriptionState.UNSUBSCRIBED) {
            return;
        }
        if (this.getState() == SubscriptionState.SUBSCRIBED) {
            this.clearSubscribedState();
        } else if (this.getState() == SubscriptionState.SUBSCRIBING) {
            this.clearSubscribingState();
        }
        this.setState(SubscriptionState.UNSUBSCRIBED);
        if (sendUnsubscribe) {
            this.client.sendUnsubscribe(this.getChannel());
        }
        for (Map.Entry<String, CompletableFuture<Throwable>> entry : this.futures.entrySet()) {
            CompletableFuture<Throwable> f = entry.getValue();
            f.complete((Object)new SubscriptionStateError(this.getState()));
        }
        this.futures.clear();
        this.listener.onUnsubscribed(this, new UnsubscribedEvent(code, reason));
    }

    private void scheduleResubscribe() {
        if (this.getState() != SubscriptionState.SUBSCRIBING) {
            return;
        }
        this.resubscribeTask = this.client.getScheduler().schedule(this::startResubscribing, this.backoff.duration(this.resubscribeAttempts, this.opts.getMinResubscribeDelay(), this.opts.getMaxResubscribeDelay()), TimeUnit.MILLISECONDS);
        ++this.resubscribeAttempts;
    }

    void startResubscribing() {
        this.client.getExecutor().submit(this::sendSubscribe);
    }

    boolean getRecover() {
        return this.recover;
    }

    private void failUnauthorized(boolean sendUnsubscribe) {
        this._unsubscribe(sendUnsubscribe, 1, "unauthorized");
    }

    public void publish(byte[] data, ResultCallback<PublishResult> cb) {
        this.client.getExecutor().submit(() -> this.publishSynchronized(data, cb));
    }

    private void publishSynchronized(byte[] data, ResultCallback<PublishResult> cb) {
        CompletableFuture f = new CompletableFuture();
        String uuid = UUID.randomUUID().toString();
        this.futures.put(uuid, (CompletableFuture<Throwable>)f);
        f.thenAccept(err -> {
            if (err != null) {
                cb.onDone((Throwable)err, (PublishResult)null);
                return;
            }
            this.futures.remove(uuid);
            this.client.publish(this.getChannel(), data, cb);
        }).orTimeout((long)this.client.getOpts().getTimeout(), TimeUnit.MILLISECONDS).exceptionally(e -> {
            this.futures.remove(uuid);
            cb.onDone((Throwable)e, (PublishResult)null);
            return null;
        });
        if (this.getState() == SubscriptionState.SUBSCRIBED) {
            f.complete(null);
        }
    }

    public void history(HistoryOptions opts, ResultCallback<HistoryResult> cb) {
        this.client.getExecutor().submit(() -> this.historySynchronized(opts, cb));
    }

    private void historySynchronized(HistoryOptions opts, ResultCallback<HistoryResult> cb) {
        CompletableFuture f = new CompletableFuture();
        String uuid = UUID.randomUUID().toString();
        this.futures.put(uuid, (CompletableFuture<Throwable>)f);
        f.thenAccept(err -> {
            if (err != null) {
                cb.onDone((Throwable)err, (HistoryResult)null);
                return;
            }
            this.futures.remove(uuid);
            this.client.history(this.getChannel(), opts, cb);
        }).orTimeout((long)this.client.getOpts().getTimeout(), TimeUnit.MILLISECONDS).exceptionally(e -> {
            this.futures.remove(uuid);
            cb.onDone((Throwable)e, (HistoryResult)null);
            return null;
        });
        if (this.getState() == SubscriptionState.SUBSCRIBED) {
            f.complete(null);
        }
    }

    public void presence(ResultCallback<PresenceResult> cb) {
        this.client.getExecutor().submit(() -> this.presenceSynchronized(cb));
    }

    private void presenceSynchronized(ResultCallback<PresenceResult> cb) {
        CompletableFuture f = new CompletableFuture();
        String uuid = UUID.randomUUID().toString();
        this.futures.put(uuid, (CompletableFuture<Throwable>)f);
        f.thenAccept(err -> {
            if (err != null) {
                cb.onDone((Throwable)err, (PresenceResult)null);
                return;
            }
            this.futures.remove(uuid);
            this.client.presence(this.getChannel(), cb);
        }).orTimeout((long)this.client.getOpts().getTimeout(), TimeUnit.MILLISECONDS).exceptionally(e -> {
            this.futures.remove(uuid);
            cb.onDone((Throwable)e, (PresenceResult)null);
            return null;
        });
        if (this.getState() == SubscriptionState.SUBSCRIBED) {
            f.complete(null);
        }
    }

    public void presenceStats(ResultCallback<PresenceStatsResult> cb) {
        this.client.getExecutor().submit(() -> this.presenceStatsSynchronized(cb));
    }

    private void presenceStatsSynchronized(ResultCallback<PresenceStatsResult> cb) {
        CompletableFuture f = new CompletableFuture();
        String uuid = UUID.randomUUID().toString();
        this.futures.put(uuid, (CompletableFuture<Throwable>)f);
        f.thenAccept(err -> {
            if (err != null) {
                cb.onDone((Throwable)err, (PresenceStatsResult)null);
                return;
            }
            this.futures.remove(uuid);
            this.client.presenceStats(this.getChannel(), cb);
        }).orTimeout((long)this.client.getOpts().getTimeout(), TimeUnit.MILLISECONDS).exceptionally(e -> {
            this.futures.remove(uuid);
            cb.onDone((Throwable)e, (PresenceStatsResult)null);
            return null;
        });
        if (this.getState() == SubscriptionState.SUBSCRIBED) {
            f.complete(null);
        }
    }

    private byte[] getPrevData() {
        return this.prevData;
    }

    private void setPrevData(byte[] prevData) {
        this.prevData = prevData;
    }
}

