/*
 * Decompiled with CFR 0.152.
 */
package io.github.cernier.yml2props;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.DirectoryScanner;
import org.yaml.snakeyaml.Yaml;

@Mojo(name="convert", defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public class Yml2PropsConvertMojo
extends AbstractMojo {
    @Parameter(property="includes", defaultValue="**/*.yml,**/*.yaml", required=true)
    private String includes;
    @Parameter(property="inputDirectory", defaultValue="${project.build.outputDirectory}", required=true)
    private File inputDirectory;
    @Parameter(property="inputCharset", defaultValue="UTF-8", required=true)
    private String inputCharset;
    @Parameter(property="outputCharset", defaultValue="UTF-8", required=true)
    private String outputCharset;
    @Parameter(property="deleteOriginalFileAfterSuccessfulConversion", defaultValue="true", required=true)
    private boolean deleteOriginalFileAfterSuccessfulConversion;

    public void setIncludes(String includes) {
        this.includes = includes;
    }

    public void setInputDirectory(File inputDirectory) {
        this.inputDirectory = inputDirectory;
    }

    public void setInputCharset(String inputCharset) {
        this.inputCharset = inputCharset;
    }

    public void setOutputCharset(String outputCharset) {
        this.outputCharset = outputCharset;
    }

    public void setDeleteOriginalFileAfterSuccessfulConversion(boolean deleteOriginalFileAfterSuccessfulConversion) {
        this.deleteOriginalFileAfterSuccessfulConversion = deleteOriginalFileAfterSuccessfulConversion;
    }

    public void execute() throws MojoExecutionException {
        for (String fileName : this.relativeFilesToConvert()) {
            try {
                File sourceFile = new File(this.inputDirectory, fileName);
                this.convertFile(sourceFile);
                if (!this.deleteOriginalFileAfterSuccessfulConversion) continue;
                sourceFile.delete();
            }
            catch (IOException e) {
                new MojoExecutionException(String.format("Failed to convert: %s", fileName), (Exception)e);
            }
        }
    }

    private String[] relativeFilesToConvert() {
        DirectoryScanner dirScanner = new DirectoryScanner();
        dirScanner.setBasedir(this.inputDirectory);
        dirScanner.setIncludes(StringUtils.split((String)this.includes, (String)","));
        dirScanner.scan();
        return dirScanner.getIncludedFiles();
    }

    private void convertFile(File ymlFile) throws IOException {
        InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(ymlFile), this.inputCharset);
        Properties properties = Yml2PropsConvertMojo.toProperties((Map)new Yaml().loadAs((Reader)isr, TreeMap.class));
        File propertyFile = new File(ymlFile.getParent(), FilenameUtils.removeExtension((String)ymlFile.getName()) + ".properties");
        properties.store(new OutputStreamWriter((OutputStream)new FileOutputStream(propertyFile), Charset.forName(this.outputCharset)), "");
    }

    private static Properties toProperties(Map<String, Object> propertiesMap) {
        return Yml2PropsConvertMojo.toProperties(propertiesMap, "");
    }

    private static Properties toProperties(Map<String, Object> propertiesMap, String keyPrefix) {
        return Yml2PropsConvertMojo.toProperties(propertiesMap, keyPrefix, new Properties());
    }

    private static Properties toProperties(Object propertiesNode, String keyPrefix, Properties properties) {
        if (propertiesNode instanceof Map) {
            return Yml2PropsConvertMojo.toProperties((Map)propertiesNode, keyPrefix, properties);
        }
        if (propertiesNode instanceof List) {
            return Yml2PropsConvertMojo.toProperties((List)propertiesNode, keyPrefix, properties);
        }
        properties.put(keyPrefix, propertiesNode.toString());
        return properties;
    }

    private static Properties toProperties(Map<String, Object> propertiesMap, String keyPrefix, Properties properties) {
        propertiesMap.forEach((key, value) -> {
            String fullKey = StringUtils.isNotEmpty((CharSequence)keyPrefix) ? String.format("%s.%s", keyPrefix, key) : key;
            Yml2PropsConvertMojo.toProperties(value, fullKey, properties);
        });
        return properties;
    }

    private static Properties toProperties(List<Object> propertiesList, String keyPrefix, Properties properties) {
        propertiesList.forEach(item -> {
            String fullKey = String.format("%s[%d]", keyPrefix, propertiesList.indexOf(item));
            Yml2PropsConvertMojo.toProperties(item, fullKey, properties);
        });
        return properties;
    }
}

