package com.cerve.development.data.result

sealed class CerveResult<T>(val data: T?) {

    data class Success<T>(val value: T): CerveResult<T>(value)

    data class Error<T>(
        val value: T? = null,
        val errorMessage: String? = null
    ): CerveResult<T>(value)

    val message = if (this is Error) errorMessage else null

    companion object {

        inline infix fun <T, R> CerveResult<T>.mapIfSuccess(
            onResult: (T) -> R
        ) : R? = when (this) {
            is Success -> onResult(value)
            is Error -> null
        }

        inline infix fun <T, R> CerveResult<T>.mapIfError(
            onResult: (T?) -> R
        ) : R? = when (this) {
            is Success -> null
            is Error -> onResult(value)
        }

        inline infix fun <T, R> CerveResult<T>.ifError(
            onResult: (T?) -> R
        ) : R? = if (this is Error) onResult(data) else null

        infix fun <T, R> CerveResult<T>.ifSuccess(
            onResult: CerveResult<T>.() -> R
        ) = Ternary(this is Success, onResult, this)

        infix fun  <R, Y, K: (CerveResult<Y>) -> R> Ternary<K, Y>.ifError(
            onResult: K
        ) = if (condition) {
            onTernaryResult(result)
        } else onResult(result)

    }
}
