package com.cerve.development.ui.canvas.model

import kotlinx.serialization.Serializable
import kotlin.uuid.ExperimentalUuidApi
import kotlin.uuid.Uuid

@Serializable
data class CerveLine(
    val start: CerveOffset,
    val end: CerveOffset
) {

    @OptIn(ExperimentalUuidApi::class)
    val id : String = Uuid.random().toHexString()

    companion object {
        fun defaultCerveLine(
            start: CerveOffset,
            end: CerveOffset
        ) = CerveLine(
            start = start,
            end = end
        )
    }
}
