package com.cerve.development.ui.canvas.model

import androidx.compose.ui.geometry.Offset
import kotlinx.serialization.Serializable

@Serializable
data class CerveOffset(
    val x: Double,
    val y: Double
) {
    fun toStandardOffset() : Offset = Offset(x = x.toFloat(), y = y.toFloat())

    companion object {
        fun Offset.toCerveOffset() : CerveOffset = CerveOffset(x = x.toDouble(), y = y.toDouble())
    }
}
