package com.cerve.development.ui.canvas.operators

import androidx.compose.foundation.gestures.detectDragGestures
import androidx.compose.ui.input.pointer.PointerInputScope
import com.cerve.development.ui.canvas.model.CerveLine
import com.cerve.development.ui.canvas.model.CerveLine.Companion.defaultCerveLine
import com.cerve.development.ui.canvas.model.CerveOffset

suspend fun PointerInputScope.eraserGestures(
    stepSize: Float,
    currentLines: MutableList<CerveLine>,
    eraserLines: MutableList<CerveLine>
) = detectDragGestures(
    onDragEnd = {
        val x = eraserLines.first().start.x
        val y = eraserLines.first().start.y

        val xx = eraserLines.last().start.x
        val yy = eraserLines.last().start.y

        val eraserLine = defaultCerveLine(
            start = CerveOffset(x, y),
            end = CerveOffset(xx, yy)
        )

        currentLines.removeAll { line ->
            line.checkLineIntersectionsOffset(eraserLine)
        }

        currentLines.removeAll { line ->
            !line.travelsAtLeast(stepSize.div(6))
        }

        eraserLines.clear()
    },
    onDrag = { change, dragAmount ->
        eraserLines.consumeLine(change, dragAmount)
    }
)

suspend fun PointerInputScope.assistedBrushGestures(
    stepSize: Float,
    currentLines: MutableList<CerveLine>,
    currentLineCandidates: MutableList<CerveLine>
) = detectDragGestures(
    onDragEnd = {

        val optimised = currentLineCandidates.convertAndNapToNearest(stepSize)
        val extracted = extractLineSegments(optimised)
        val redrawnLines = extracted.groupByOffset()

        currentLineCandidates.clear()
        currentLines.addAll(redrawnLines)

    },
    onDrag = { change, dragAmount ->
        currentLineCandidates.consumeLine(change, dragAmount)
    }
)

suspend fun PointerInputScope.segmentedBrushGestures(
    stepSize: Float,
    currentLines: MutableList<CerveLine>,
    currentLineCandidates: MutableList<CerveLine>
) = detectDragGestures(
    onDragEnd = {

        val redrawnLine = currentLineCandidates.snapNearestLine(stepSize)
        currentLineCandidates.clear()

        currentLines.divideAndAddLine(redrawnLine)

    },
    onDrag = { change, dragAmount ->
        currentLineCandidates.consumeLine(change, dragAmount)
    }
)

suspend fun PointerInputScope.brushGestures(
    currentLines: MutableList<CerveLine>
) = detectDragGestures(
    onDrag = { change, dragAmount ->
        currentLines.consumeLine(change, dragAmount)
    }
)

