package com.cerve.development.ui.canvas.operators

import androidx.compose.ui.geometry.Offset
import com.cerve.development.ui.canvas.model.CerveLine
import com.cerve.development.ui.canvas.model.CerveOffset
import com.cerve.development.ui.canvas.model.CerveOffset.Companion.toCerveOffset

fun extractLineSegments(cerveOffsets: List<CerveOffset>): List<CerveLine> {
    val filteredOffsets = cerveOffsets.filterIndexed { index, offset ->
        index == 0 || offset != cerveOffsets[index - 1]
    }.map { Offset(it.x.toFloat(), it.y.toFloat()) }

    val lineSegments = mutableListOf<CerveLine>()
    val currentLine = mutableListOf<Offset>()

    val gapThreshold = 50f // Adjust this threshold as needed

    for (i in filteredOffsets.indices) {
        val currentPoint = filteredOffsets[i]
        currentLine.add(currentPoint)

        if (i < filteredOffsets.size - 1) {
            val nextPoint = filteredOffsets[i + 1]
            val distance = (currentPoint - nextPoint).cerveDistance()

            if (distance > gapThreshold) {
                // Line break detected
                if (currentLine.size >= 2) { // Ensure at least 2 points for a line
                    lineSegments.add(CerveLine(currentLine.first().toCerveOffset(), currentLine.last().toCerveOffset()))
                } else if (currentLine.size == 1) {
                    //If only one point, add a zero length line.
                    lineSegments.add(CerveLine(currentLine.first().toCerveOffset(), currentLine.first().toCerveOffset()))
                }
                currentLine.clear()
            }
        } else {
            // Last point
            if (currentLine.size >= 2) { // Ensure at least 2 points for a line
                lineSegments.add(CerveLine(currentLine.first().toCerveOffset(), currentLine.last().toCerveOffset()))
            } else if (currentLine.size == 1) {
                //If only one point, add a zero length line.
                lineSegments.add(CerveLine(currentLine.first().toCerveOffset(), currentLine.first().toCerveOffset()))
            }
        }
    }

    return lineSegments
}