package com.cerve.development.ui.canvas.operators

import androidx.compose.ui.geometry.Offset
import com.cerve.development.ui.canvas.model.CerveLine
import com.cerve.development.ui.canvas.model.CerveOffset.Companion.toCerveOffset
import kotlin.math.round
import kotlin.math.roundToLong

fun CerveLine.snapNearest(
    stepSize: Float,
) : Offset {
    val x = round((start.x.div(stepSize).roundToLong()).times(stepSize).toFloat())
    val y = round((start.y.div(stepSize).roundToLong()).times(stepSize).toFloat())

    return Offset(x, y)
}

fun List<CerveLine>.snapNearestLine(
    stepSize: Float,
) : CerveLine {
    val start = first().snapNearest(stepSize).toCerveOffset()
    val end = last().snapNearest(stepSize).toCerveOffset()
    return CerveLine(start, end)
}