package com.cerve.development.ui.canvas.model

import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateListOf
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.setValue
import androidx.compose.runtime.snapshots.SnapshotStateList

data class CerveDrawCanvasState(
    val initialLines: List<CerveLine> = emptyList(),
    val historyLines: SnapshotStateList<CerveLine> = mutableStateListOf<CerveLine>(),
    val eraserLines: SnapshotStateList<CerveLine> = mutableStateListOf<CerveLine>(),
    val currentLines: SnapshotStateList<CerveLine> = mutableStateListOf<CerveLine>(),
    val currentLineCandidates: SnapshotStateList<CerveLine> = mutableStateListOf<CerveLine>()
) {

    var interactionType by mutableStateOf<CerveCanvasInteractionType?>(null)
        private set

    init { currentLines.addAll(initialLines) }

    fun onChangeInteractionType(
        type: CerveCanvasInteractionType
    ) { interactionType = type }

    fun onUndo() {
        val removed = currentLines.removeLastOrNull()
        removed?.let { historyLines.add(removed) }
    }

    fun onRedo() {
        val history = historyLines.removeLastOrNull()
        history?.let { currentLines.add(history) }
    }

    fun onClear() {
        historyLines.clear()
        eraserLines.clear()
        currentLines.clear()
        currentLineCandidates.clear()
    }

    fun onSave() {
        println(currentLines.toList().toString())
    }

}