package com.cerve.development.ui.canvas.operators

import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.drawWithCache
import androidx.compose.ui.geometry.Offset
import androidx.compose.ui.graphics.Color

fun Modifier.drawGridBehind(
    color: Color,
    stepSize: Float,
    showGridLine: Boolean = true
) : Modifier = (
    if (showGridLine) {
        drawWithCache {
            onDrawBehind {
                val width = size.width
                val height = size.height

                // Draw vertical lines
                for (x in 0..((width / stepSize).toInt())) {
                    drawLine(
                        start = Offset(x = x * stepSize, y = 0f),
                        end = Offset(x = x * stepSize, y = height),
                        color = color
                    )

                }

                // Draw horizontal lines
                for (y in 0..((height / stepSize).toInt())) {
                    drawLine(
                        start = Offset(x = 0f, y = y * stepSize),
                        end = Offset(x = width, y = y * stepSize),
                        color = color
                    )
                }
            }
        }
    } else this
)