package com.cerve.development.ui.canvas.operators

import com.cerve.development.ui.canvas.model.CerveLine
import com.cerve.development.ui.canvas.model.CerveOffset

fun MutableList<CerveLine>.divideAndAddLine(newLine: CerveLine): List<CerveLine> {
    val intersections = mutableListOf<CerveOffset>()
    val modifications = mutableListOf<Pair<Int, List<CerveLine>>>()

    forEachIndexed { index, existingLine ->
        newLine.findIntersectionOffset(existingLine)?.let { intersection ->
            intersections.add(intersection)

            val dividedExisting = listOf(intersection).divideLine(existingLine)
            if (dividedExisting.size > 1) {
                modifications.add(Pair(index, dividedExisting))
            }
        }
    }

    // Apply modifications in reverse order to avoid index shifting issues
    modifications.reversed().forEach { (index, dividedLines) ->
        if (index < size) { //Ensure index is in bounds.
            removeAt(index)
            addAll(index, dividedLines)
        }
    }

    val dividedNewLine = intersections.divideLine(newLine)
    addAll(dividedNewLine)

    return this
}

fun List<CerveOffset>.divideLine(line: CerveLine): List<CerveLine> {
    val relevantIntersections = filter { offset -> line.isPointOnLine(offset) }
        .sortedBy { offset -> offset.distanceBetween(line.start) }

    if (relevantIntersections.isEmpty()) {
        return listOf(line)
    }

    val dividedLines = mutableListOf<CerveLine>()
    var currentStart = line.start
    relevantIntersections.forEach { intersection ->
        dividedLines.add(CerveLine(currentStart, intersection))
        currentStart = intersection
    }
    dividedLines.add(CerveLine(currentStart, line.end))
    return dividedLines
}
