package com.cerve.development.ui.canvas.operators

import com.cerve.development.ui.canvas.model.CerveLine
import com.cerve.development.ui.canvas.model.CerveOffset

fun List<CerveLine>.groupByOffsetX() : List<CerveLine> {
    return groupBy { line -> line.start.x }.mapValues { entry ->
        val startLine = entry.value.minOf { line -> line.start.y }
        val endLine = entry.value.maxOf { line -> line.start.y }

        val start = CerveOffset(x = entry.key, y = startLine)
        val end = CerveOffset(x = entry.key, y = endLine)

        CerveLine(start, end)
    }.filterValues { value -> value.start != value.end }.values.toList()
}

fun List<CerveLine>.groupByOffsetY() : List<CerveLine> {
    return groupBy { line -> line.start.y }.mapValues { entry ->
        val startLine = entry.value.minOf { line -> line.start.x }
        val endLine = entry.value.maxOf { line -> line.start.x }

        val start = CerveOffset(y = entry.key, x = startLine)
        val end = CerveOffset(y = entry.key, x = endLine)

        CerveLine(start, end)
    }.filterValues { value -> value.start != value.end }.values.toList()
}

fun List<CerveLine>.groupByOffset() : List<CerveLine> {
    return flatMap { groupByOffsetX() + groupByOffsetY() }
}