package com.cerve.development.ui.canvas.operators

import androidx.compose.ui.geometry.Offset
import com.cerve.development.ui.canvas.model.CerveLine
import com.cerve.development.ui.canvas.model.CerveOffset
import kotlin.math.abs
import kotlin.math.sqrt

fun orientationOffset(p: Offset, q: Offset, r: Offset): Int {
    val value = (q.y - p.y) * (r.x - q.x) - (q.x - p.x) * (r.y - q.y)
    return when {
        value == 0f -> 0 // Collinear
        value > 0f -> 1 // Clockwise
        else -> 2 // Counterclockwise
    }
}

fun onSegmentOffset(p: Offset, q: Offset, r: Offset): Boolean {
    return q.x <= maxOf(p.x, r.x) && q.x >= minOf(p.x, r.x) &&
            q.y <= maxOf(p.y, r.y) && q.y >= minOf(p.y, r.y)
}

fun CerveOffset.distanceBetween(other: CerveOffset): Double {
    return sqrt((x - other.x) * (x - other.x) + (y - other.y) * (y - other.y))
}

fun CerveLine.isPointOnLine(offset: CerveOffset): Boolean {
    val dxLine = end.x - start.x
    val dyLine = end.y - start.y
    val dxPoint = offset.x - start.x
    val dyPoint = offset.y - start.y

    //Early returns for the most likely false conditions
    if (dxLine == 0.0 && offset.x != start.x) return false
    if (dyLine == 0.0 && offset.y != start.y) return false

    val crossProduct = dxPoint * dyLine - dyPoint * dxLine
    if (abs(crossProduct) > 1e-6) return false // Use a small tolerance for floating-point comparisons

    val dotProduct = dxPoint * dxLine + dyPoint * dyLine
    if (dotProduct < 0) return false

    val squaredLength = dxLine * dxLine + dyLine * dyLine
    if (dotProduct > squaredLength) return false

    return true
}