package com.cerve.development.ui.canvas.operators

import androidx.compose.ui.Modifier
import androidx.compose.ui.geometry.Offset
import androidx.compose.ui.input.pointer.PointerInputChange
import androidx.compose.ui.input.pointer.pointerInput
import com.cerve.development.ui.canvas.model.CerveCanvasInteractionType
import com.cerve.development.ui.canvas.model.CerveLine
import com.cerve.development.ui.canvas.model.CerveLine.Companion.defaultCerveLine
import com.cerve.development.ui.canvas.model.CerveOffset.Companion.toCerveOffset

fun Modifier.canvasInput(
    key: CerveCanvasInteractionType?,
    stepSize: Float,
    eraserLines: MutableList<CerveLine>,
    currentLines: MutableList<CerveLine>,
    currentLineCandidates: MutableList<CerveLine>
) = pointerInput(key) {
    when(key) {
        null -> Unit
        CerveCanvasInteractionType.Brush -> {
            brushGestures(
                currentLines = currentLines
            )
        }
        CerveCanvasInteractionType.AssistedBrush -> {
            assistedBrushGestures(
                stepSize = stepSize,
                currentLines = currentLines,
                currentLineCandidates = currentLineCandidates
            )
        }
        CerveCanvasInteractionType.SegmentedBrush -> {
            segmentedBrushGestures(
                stepSize = stepSize,
                currentLines = currentLines,
                currentLineCandidates = currentLineCandidates
            )
        }
        CerveCanvasInteractionType.Eraser -> {
            eraserGestures(
                stepSize = stepSize,
                eraserLines = eraserLines,
                currentLines = currentLines,
            )
        }
    }
}

fun MutableList<CerveLine>.consumeLine(change: PointerInputChange, dragAmount: Offset) {
    change.consume()
    val line = defaultCerveLine(
        start = (change.position - dragAmount).toCerveOffset(),
        end = (change.position).toCerveOffset()
    )

    add(line)
}