package com.cerve.development.ui.canvas.operators

import androidx.compose.ui.geometry.Offset
import com.cerve.development.ui.canvas.model.CerveLine
import kotlin.math.abs

fun CerveLine.travelsAtLeast(distance: Float): Boolean {
    val deltaX = abs(end.x - start.x)
    val deltaY = abs(end.y - start.y)
    return deltaX >= distance || deltaY >= distance
}
fun Offset.cerveDistance(): Float {
    return kotlin.math.sqrt(x * x + y * y)
}