/*
 * Decompiled with CFR 0.152.
 */
package com.cerve.development.ui.canvas.operators;

import androidx.compose.foundation.gestures.DragGestureDetectorKt;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.input.pointer.PointerInputChange;
import androidx.compose.ui.input.pointer.PointerInputScope;
import com.cerve.development.ui.canvas.model.CerveLine;
import com.cerve.development.ui.canvas.model.CerveOffset;
import com.cerve.development.ui.canvas.operators.ConvertersKt;
import com.cerve.development.ui.canvas.operators.DivideKt;
import com.cerve.development.ui.canvas.operators.GroupKt;
import com.cerve.development.ui.canvas.operators.IntersectionKt;
import com.cerve.development.ui.canvas.operators.LineSegmentKt;
import com.cerve.development.ui.canvas.operators.PointerInputKt;
import com.cerve.development.ui.canvas.operators.RoundKt;
import com.cerve.development.ui.canvas.operators.TravelKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\u001a6\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0086@\u00a2\u0006\u0002\u0010\t\u001a6\u0010\n\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0086@\u00a2\u0006\u0002\u0010\t\u001a6\u0010\f\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0086@\u00a2\u0006\u0002\u0010\t\u001a \u0010\r\u001a\u00020\u0001*\u00020\u00022\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0086@\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"eraserGestures", "", "Landroidx/compose/ui/input/pointer/PointerInputScope;", "stepSize", "", "currentLines", "", "Lcom/cerve/development/ui/canvas/model/CerveLine;", "eraserLines", "(Landroidx/compose/ui/input/pointer/PointerInputScope;FLjava/util/List;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "assistedBrushGestures", "currentLineCandidates", "segmentedBrushGestures", "brushGestures", "(Landroidx/compose/ui/input/pointer/PointerInputScope;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "canvas_release"})
public final class GesturesKt {
    @Nullable
    public static final Object eraserGestures(@NotNull PointerInputScope $this$eraserGestures, float stepSize, @NotNull List<CerveLine> currentLines, @NotNull List<CerveLine> eraserLines, @NotNull Continuation<? super Unit> $completion) {
        Object object = DragGestureDetectorKt.detectDragGestures$default((PointerInputScope)$this$eraserGestures, null, () -> GesturesKt.eraserGestures$lambda$2(eraserLines, currentLines, stepSize), null, (arg_0, arg_1) -> GesturesKt.eraserGestures$lambda$3(eraserLines, arg_0, arg_1), $completion, (int)5, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public static final Object assistedBrushGestures(@NotNull PointerInputScope $this$assistedBrushGestures, float stepSize, @NotNull List<CerveLine> currentLines, @NotNull List<CerveLine> currentLineCandidates, @NotNull Continuation<? super Unit> $completion) {
        Object object = DragGestureDetectorKt.detectDragGestures$default((PointerInputScope)$this$assistedBrushGestures, null, () -> GesturesKt.assistedBrushGestures$lambda$4(currentLineCandidates, stepSize, currentLines), null, (arg_0, arg_1) -> GesturesKt.assistedBrushGestures$lambda$5(currentLineCandidates, arg_0, arg_1), $completion, (int)5, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public static final Object segmentedBrushGestures(@NotNull PointerInputScope $this$segmentedBrushGestures, float stepSize, @NotNull List<CerveLine> currentLines, @NotNull List<CerveLine> currentLineCandidates, @NotNull Continuation<? super Unit> $completion) {
        Object object = DragGestureDetectorKt.detectDragGestures$default((PointerInputScope)$this$segmentedBrushGestures, null, () -> GesturesKt.segmentedBrushGestures$lambda$6(currentLineCandidates, stepSize, currentLines), null, (arg_0, arg_1) -> GesturesKt.segmentedBrushGestures$lambda$7(currentLineCandidates, arg_0, arg_1), $completion, (int)5, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public static final Object brushGestures(@NotNull PointerInputScope $this$brushGestures, @NotNull List<CerveLine> currentLines, @NotNull Continuation<? super Unit> $completion) {
        Object object = DragGestureDetectorKt.detectDragGestures$default((PointerInputScope)$this$brushGestures, null, null, null, (arg_0, arg_1) -> GesturesKt.brushGestures$lambda$8(currentLines, arg_0, arg_1), $completion, (int)7, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private static final boolean eraserGestures$lambda$2$lambda$0(CerveLine $eraserLine, CerveLine line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        return IntersectionKt.checkLineIntersectionsOffset(line, $eraserLine);
    }

    private static final boolean eraserGestures$lambda$2$lambda$1(float $stepSize, CerveLine line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        return !TravelKt.travelsAtLeast(line, $stepSize / (float)6);
    }

    private static final Unit eraserGestures$lambda$2(List $eraserLines, List $currentLines, float $stepSize) {
        double x = ((CerveLine)CollectionsKt.first((List)$eraserLines)).getStart().getX();
        double y = ((CerveLine)CollectionsKt.first((List)$eraserLines)).getStart().getY();
        double xx = ((CerveLine)CollectionsKt.last((List)$eraserLines)).getStart().getX();
        double yy = ((CerveLine)CollectionsKt.last((List)$eraserLines)).getStart().getY();
        CerveLine eraserLine = CerveLine.Companion.defaultCerveLine(new CerveOffset(x, y), new CerveOffset(xx, yy));
        CollectionsKt.removeAll((List)$currentLines, arg_0 -> GesturesKt.eraserGestures$lambda$2$lambda$0(eraserLine, arg_0));
        CollectionsKt.removeAll((List)$currentLines, arg_0 -> GesturesKt.eraserGestures$lambda$2$lambda$1($stepSize, arg_0));
        $eraserLines.clear();
        return Unit.INSTANCE;
    }

    private static final Unit eraserGestures$lambda$3(List $eraserLines, PointerInputChange change, Offset dragAmount) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        PointerInputKt.consumeLine-0AR0LA0($eraserLines, change, dragAmount.unbox-impl());
        return Unit.INSTANCE;
    }

    private static final Unit assistedBrushGestures$lambda$4(List $currentLineCandidates, float $stepSize, List $currentLines) {
        List<CerveOffset> optimised = ConvertersKt.convertAndNapToNearest($currentLineCandidates, $stepSize);
        List<CerveLine> extracted = LineSegmentKt.extractLineSegments(optimised);
        List<CerveLine> redrawnLines = GroupKt.groupByOffset(extracted);
        $currentLineCandidates.clear();
        $currentLines.addAll((Collection)redrawnLines);
        return Unit.INSTANCE;
    }

    private static final Unit assistedBrushGestures$lambda$5(List $currentLineCandidates, PointerInputChange change, Offset dragAmount) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        PointerInputKt.consumeLine-0AR0LA0($currentLineCandidates, change, dragAmount.unbox-impl());
        return Unit.INSTANCE;
    }

    private static final Unit segmentedBrushGestures$lambda$6(List $currentLineCandidates, float $stepSize, List $currentLines) {
        CerveLine redrawnLine = RoundKt.snapNearestLine($currentLineCandidates, $stepSize);
        $currentLineCandidates.clear();
        DivideKt.divideAndAddLine($currentLines, redrawnLine);
        return Unit.INSTANCE;
    }

    private static final Unit segmentedBrushGestures$lambda$7(List $currentLineCandidates, PointerInputChange change, Offset dragAmount) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        PointerInputKt.consumeLine-0AR0LA0($currentLineCandidates, change, dragAmount.unbox-impl());
        return Unit.INSTANCE;
    }

    private static final Unit brushGestures$lambda$8(List $currentLines, PointerInputChange change, Offset dragAmount) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        PointerInputKt.consumeLine-0AR0LA0($currentLines, change, dragAmount.unbox-impl());
        return Unit.INSTANCE;
    }
}

