/*
 * Decompiled with CFR 0.152.
 */
package com.cerve.development.ui.canvas.operators;

import com.cerve.development.ui.canvas.model.CerveLine;
import com.cerve.development.ui.canvas.model.CerveOffset;
import com.cerve.development.ui.canvas.operators.OffsetKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002\u001a\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002\u00a8\u0006\u0006"}, d2={"checkLineIntersectionsOffset", "", "Lcom/cerve/development/ui/canvas/model/CerveLine;", "intersectingLine", "findIntersectionOffset", "Lcom/cerve/development/ui/canvas/model/CerveOffset;", "canvas_release"})
public final class IntersectionKt {
    public static final boolean checkLineIntersectionsOffset(@NotNull CerveLine $this$checkLineIntersectionsOffset, @NotNull CerveLine intersectingLine) {
        Intrinsics.checkNotNullParameter((Object)$this$checkLineIntersectionsOffset, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)intersectingLine, (String)"intersectingLine");
        long p1 = $this$checkLineIntersectionsOffset.getStart().toStandardOffset-F1C5BW0();
        long q1 = $this$checkLineIntersectionsOffset.getEnd().toStandardOffset-F1C5BW0();
        long p2 = intersectingLine.getStart().toStandardOffset-F1C5BW0();
        long q2 = intersectingLine.getEnd().toStandardOffset-F1C5BW0();
        int o1 = OffsetKt.orientationOffset-r6Wi-ys(p1, q1, p2);
        int o2 = OffsetKt.orientationOffset-r6Wi-ys(p1, q1, q2);
        int o3 = OffsetKt.orientationOffset-r6Wi-ys(p2, q2, p1);
        int o4 = OffsetKt.orientationOffset-r6Wi-ys(p2, q2, q1);
        if (o1 != o2 && o3 != o4) {
            return true;
        }
        if (o1 == 0 && OffsetKt.onSegmentOffset-r6Wi-ys(p1, p2, q1)) {
            return true;
        }
        if (o2 == 0 && OffsetKt.onSegmentOffset-r6Wi-ys(p1, q2, q1)) {
            return true;
        }
        if (o3 == 0 && OffsetKt.onSegmentOffset-r6Wi-ys(p2, p1, q2)) {
            return true;
        }
        return o4 == 0 && OffsetKt.onSegmentOffset-r6Wi-ys(p2, q1, q2);
    }

    @Nullable
    public static final CerveOffset findIntersectionOffset(@NotNull CerveLine $this$findIntersectionOffset, @NotNull CerveLine intersectingLine) {
        Intrinsics.checkNotNullParameter((Object)$this$findIntersectionOffset, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)intersectingLine, (String)"intersectingLine");
        CerveOffset cerveOffset = $this$findIntersectionOffset.getStart();
        double x1 = cerveOffset.component1();
        double y1 = cerveOffset.component2();
        CerveOffset cerveOffset2 = $this$findIntersectionOffset.getEnd();
        double x2 = cerveOffset2.component1();
        double y2 = cerveOffset2.component2();
        CerveOffset cerveOffset3 = intersectingLine.getStart();
        double x3 = cerveOffset3.component1();
        double y3 = cerveOffset3.component2();
        CerveOffset cerveOffset4 = intersectingLine.getEnd();
        double x4 = cerveOffset4.component1();
        double y4 = cerveOffset4.component2();
        if (Math.max(x1, x2) < Math.min(x3, x4) || Math.min(x1, x2) > Math.max(x3, x4) || Math.max(y1, y2) < Math.min(y3, y4) || Math.min(y1, y2) > Math.max(y3, y4)) {
            return null;
        }
        double denominator = (x1 - x2) * (y3 - y4) - (y1 - y2) * (x3 - x4);
        if (denominator == 0.0) {
            return null;
        }
        double numeratorX = (x1 * y2 - y1 * x2) * (x3 - x4) - (x1 - x2) * (x3 * y4 - y3 * x4);
        double numeratorY = (x1 * y2 - y1 * x2) * (y3 - y4) - (y1 - y2) * (x3 * y4 - y3 * x4);
        double intersectionX = numeratorX / denominator;
        double intersectionY = numeratorY / denominator;
        if (intersectionX < Math.min(x1, x2) || intersectionX > Math.max(x1, x2) || intersectionX < Math.min(x3, x4) || intersectionX > Math.max(x3, x4) || intersectionY < Math.min(y1, y2) || intersectionY > Math.max(y1, y2) || intersectionY < Math.min(y3, y4) || intersectionY > Math.max(y3, y4)) {
            return null;
        }
        return new CerveOffset(intersectionX, intersectionY);
    }
}

