package com.cerve.development.ui.canvas.component

import androidx.compose.foundation.Canvas
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.runtime.Composable
import androidx.compose.runtime.State
import androidx.compose.ui.Modifier
import androidx.compose.ui.geometry.Offset
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.StrokeCap
import androidx.compose.ui.unit.Dp
import com.cerve.development.ui.canvas.model.CerveCanvasInteractionType
import com.cerve.development.ui.canvas.model.CerveLine
import com.cerve.development.ui.canvas.operators.canvasInput
import com.cerve.development.ui.canvas.operators.changeOrientation
import com.cerve.development.ui.canvas.operators.drawGridBehind

@Composable
fun CerveDrawCanvas(
    stepSize: Float,
    strokeWidth: Dp,
    currentLines: MutableList<CerveLine>,
    currentLineCandidates: MutableList<CerveLine>,
    eraserLines: MutableList<CerveLine>,
    interactionType: CerveCanvasInteractionType?,
    modifier: Modifier = Modifier,
    lineColor: Color = Color.Black,
    candidateLineColor: Color = Color.LightGray,
    gridLineColor: Color = Color.Gray,
    showGridLine: Boolean = true,
    transformationScale: State<Float>,
    transformationRotation: State<Float>,
    translationOffset: State<Offset>,
    onChangeTransformationScale: (Float) -> Unit,
    onChangeTransformationRotation: (Float) -> Unit,
    onChangeTransformationOffset: (Offset) -> Unit
) {

    Canvas(
        modifier = modifier
            .changeOrientation(
                scale = transformationScale.value,
                rotation = transformationRotation.value,
                offset = translationOffset.value
            )
            .drawGridBehind(
                color = gridLineColor,
                stepSize = stepSize,
                showGridLine = showGridLine
            )
            .canvasInput(
                key = interactionType,
                stepSize = stepSize,
                eraserLines = eraserLines,
                currentLines = currentLines,
                currentLineCandidates = currentLineCandidates,
                transformationScale = transformationScale,
                transformationRotation = transformationRotation,
                translationOffset = translationOffset,
                onChangeTransformationScale = onChangeTransformationScale,
                onChangeTransformationRotation = onChangeTransformationRotation,
                onChangeTransformationOffset = onChangeTransformationOffset
            ).fillMaxSize()
    ) {

        currentLineCandidates.forEach { line ->
            drawLine(
                color = candidateLineColor,
                start = line.start.toStandardOffset(),
                end = line.end.toStandardOffset(),
                strokeWidth = strokeWidth.toPx(),
                cap = StrokeCap.Round
            )
        }

        currentLines.forEach { line ->
            drawLine(
                color = lineColor,
                start = line.start.toStandardOffset(),
                end = line.end.toStandardOffset(),
                strokeWidth = strokeWidth.toPx(),
                cap = StrokeCap.Round
            )
        }

        eraserLines.forEach { line ->
            drawLine(
                color = Color.Transparent,
                start = line.start.toStandardOffset(),
                end = line.end.toStandardOffset(),
                strokeWidth = strokeWidth.toPx(),
                cap = StrokeCap.Round
            )
        }
    }
}