package com.cerve.development.ui.canvas.model

import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableFloatStateOf
import androidx.compose.runtime.mutableStateListOf
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.setValue
import androidx.compose.runtime.snapshots.SnapshotStateList
import androidx.compose.ui.geometry.Offset

data class CerveDrawCanvasState(
    val initialLines: List<CerveLine> = emptyList(),
    val historyLines: SnapshotStateList<CerveLine> = mutableStateListOf<CerveLine>(),
    val eraserLines: SnapshotStateList<CerveLine> = mutableStateListOf<CerveLine>(),
    val currentLines: SnapshotStateList<CerveLine> = mutableStateListOf<CerveLine>(),
    val currentLineCandidates: SnapshotStateList<CerveLine> = mutableStateListOf<CerveLine>()
) {

    var interactionType by mutableStateOf<CerveCanvasInteractionType?>(null)
        private set

    var transformationOffset = mutableStateOf(Offset.Zero)
        private set

    var transformationScale = mutableFloatStateOf(1f)
        private set

    var transformationRotation = mutableStateOf(0f)
        private set

    init { currentLines.addAll(initialLines) }

    fun onChangeInteractionType(
        type: CerveCanvasInteractionType
    ) { interactionType = type }

    fun onChangeTransformationScale(
        scale: Float
    ) { transformationScale.value = scale }

    fun onChangeTransformationRotation(
        rotation: Float
    ) { transformationRotation.value = rotation }

    fun onChangeTransformationOffset(
        offset: Offset
    ) { transformationOffset.value = offset }

    fun onUndo() {
        val removed = currentLines.removeLastOrNull()
        removed?.let { historyLines.add(removed) }
    }

    fun onRedo() {
        val history = historyLines.removeLastOrNull()
        history?.let { currentLines.add(history) }
    }

    fun onClear() {
        historyLines.clear()
        eraserLines.clear()
        currentLines.clear()
        currentLineCandidates.clear()
    }

    fun onResetAllTransformation() {
        transformationRotation.value = 0f
        transformationScale.value = 1f
        transformationOffset.value = Offset.Zero
    }

}