package com.cerve.development.ui.canvas.operators

import androidx.compose.ui.geometry.Offset
import androidx.compose.ui.input.pointer.PointerInputChange
import com.cerve.development.ui.canvas.model.CerveLine
import com.cerve.development.ui.canvas.model.CerveLine.Companion.defaultCerveLine
import com.cerve.development.ui.canvas.model.CerveOffset.Companion.toCerveOffset

fun MutableList<CerveLine>.consumeLine(change: PointerInputChange, dragAmount: Offset) {
    change.consume()
    val line = defaultCerveLine(
        start = (change.position - dragAmount).toCerveOffset(),
        end = (change.position).toCerveOffset()
    )

    add(line)
}
