package com.cerve.development.ui.canvas.operators

import com.cerve.development.ui.canvas.model.CerveLine

fun CerveLine.checkLineIntersectionsOffset(
    intersectingLine: CerveLine
): Boolean {
    val p1 = start.toStandardOffset()
    val q1 = end.toStandardOffset()
    val p2 = intersectingLine.start.toStandardOffset()
    val q2 = intersectingLine.end.toStandardOffset()

    val o1 = orientationOffset(p1, q1, p2)
    val o2 = orientationOffset(p1, q1, q2)
    val o3 = orientationOffset(p2, q2, p1)
    val o4 = orientationOffset(p2, q2, q1)

    if (o1 != o2 && o3 != o4) {
        return true
    }

    // Special Cases
    if (o1 == 0 && onSegmentOffset(p1, p2, q1)) {
        return true
    }
    if (o2 == 0 && onSegmentOffset(p1, q2, q1)) {
        return true
    }
    if (o3 == 0 && onSegmentOffset(p2, p1, q2)) {
        return true
    }
    if (o4 == 0 && onSegmentOffset(p2, q1, q2)) {
        return true
    }

    return false
}