package com.cerve.development.ui.canvas.operators

import androidx.compose.runtime.State
import androidx.compose.ui.Modifier
import androidx.compose.ui.geometry.Offset
import androidx.compose.ui.input.pointer.pointerInput
import com.cerve.development.ui.canvas.model.CerveCanvasInteractionType
import com.cerve.development.ui.canvas.model.CerveLine

fun Modifier.canvasInput(
    key: CerveCanvasInteractionType?,
    stepSize: Float,
    eraserLines: MutableList<CerveLine>,
    currentLines: MutableList<CerveLine>,
    currentLineCandidates: MutableList<CerveLine>,
    transformationScale: State<Float>,
    transformationRotation: State<Float>,
    translationOffset: State<Offset>,
    onChangeTransformationScale: (Float) -> Unit,
    onChangeTransformationRotation: (Float) -> Unit,
    onChangeTransformationOffset: (Offset) -> Unit
) = pointerInput(key) {
    when(key) {
        null -> Unit
        CerveCanvasInteractionType.Zoom -> {
            zoomGestures(
                transformationScale = transformationScale,
                transformationRotation = transformationRotation,
                translationOffset = translationOffset,
                onChangeTransformationScale = onChangeTransformationScale,
                onChangeTransformationRotation = onChangeTransformationRotation,
                onChangeTransformationOffset = onChangeTransformationOffset
            )
        }
        CerveCanvasInteractionType.Brush -> {
            brushGestures(currentLines = currentLines)
        }
        CerveCanvasInteractionType.AssistedBrush -> {
            assistedBrushGestures(
                stepSize = stepSize,
                currentLines = currentLines,
                currentLineCandidates = currentLineCandidates
            )
        }
        CerveCanvasInteractionType.SegmentedBrush -> {
            segmentedBrushGestures(
                stepSize = stepSize,
                currentLines = currentLines,
                currentLineCandidates = currentLineCandidates
            )
        }
        CerveCanvasInteractionType.Eraser -> {
            eraserGestures(
                stepSize = stepSize,
                eraserLines = eraserLines,
                currentLines = currentLines,
            )
        }
    }
}
