package com.cerve.development.ui.canvas.operators

import com.cerve.development.ui.canvas.model.CerveLine
import com.cerve.development.ui.canvas.model.CerveOffset
import kotlin.math.roundToInt

fun CerveOffset.roundToNearest(bound: Float): CerveOffset {
    val x = ((x / bound).roundToInt() * bound).toDouble()
    val y = ((y / bound).roundToInt() * bound).toDouble()
    return copy(x = x, y = y)
}

fun CerveLine.roundToNearest(bound: Float): CerveLine {
    val start = start.roundToNearest(bound)
    val end = end.roundToNearest(bound)
    return copy(start = start, end = end)
}
