package com.cerve.development.ui.canvas.operators

import androidx.compose.runtime.Composable
import androidx.compose.runtime.saveable.Saver
import androidx.compose.runtime.saveable.listSaver
import androidx.compose.runtime.saveable.rememberSaveable
import com.cerve.development.ui.canvas.model.CerveCanvasInteractionType
import com.cerve.development.ui.canvas.model.CerveDrawCanvasState
import com.cerve.development.ui.canvas.model.CerveLine
import kotlinx.serialization.json.Json

val CerveDrawCanvasStateSaver: Saver<CerveDrawCanvasState, *> = listSaver(
    save = { state ->
        listOf<String>(
            Json.encodeToString(state.initialLines),
            Json.encodeToString(state.interactionType),
            Json.encodeToString(state.historyLines.toList()),
            Json.encodeToString(state.eraserLines.toList()),
            Json.encodeToString(state.currentLines.toList()),
            Json.encodeToString(state.currentLineCandidates.toList())
        )
    },
    restore = { list ->
        CerveDrawCanvasState().apply {
            onChangeInteractionType(Json.decodeFromString<CerveCanvasInteractionType>(list[1]))

            val historyCandidate = Json.decodeFromString<List<CerveLine>>(list[2])
            historyLines.addAll(historyCandidate)

            val eraserLinesCandidate = Json.decodeFromString<List<CerveLine>>(list[3])
            eraserLines.addAll(eraserLinesCandidate)

            val currentLinesCandidate = Json.decodeFromString<List<CerveLine>>(list[4])
            currentLines.addAll(currentLinesCandidate)

            val currentLineCandidatesCandidate = Json.decodeFromString<List<CerveLine>>(list[5])
            currentLineCandidates.addAll(currentLineCandidatesCandidate)
        }
    }
)

@Composable
fun rememberCerveDrawCanvasState(
    initial: List<CerveLine> = emptyList()
) : CerveDrawCanvasState {
    return rememberSaveable(saver = CerveDrawCanvasStateSaver) {
        CerveDrawCanvasState().apply {
            currentLines.addAll(initial)
        }
    }
}