package com.cerve.development.ui.canvas.operators

import com.cerve.development.ui.canvas.model.CerveLine
import kotlin.math.abs
import kotlin.math.pow
import kotlin.math.sqrt

fun CerveLine.travelsAtLeast(distance: Float): Boolean {
    val deltaX = abs(end.x - start.x)
    val deltaY = abs(end.y - start.y)
    return deltaX >= distance || deltaY >= distance
}

fun calculateLineLength(line: CerveLine): Double {
    val dx = line.end.x - line.start.x
    val dy = line.end.y - line.start.y
    return sqrt(dx.pow(2) + dy.pow(2)).toDouble()
}