package com.cerve.development.ui.canvas.component

import androidx.compose.runtime.Composable
import androidx.compose.runtime.MutableState
import androidx.compose.runtime.State
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.ui.Modifier
import androidx.compose.ui.geometry.Offset
import androidx.compose.ui.geometry.Size
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.unit.Dp
import com.cerve.development.ui.canvas.model.CerveCanvasInteractionType
import com.cerve.development.ui.canvas.model.CerveCanvasSize
import com.cerve.development.ui.canvas.model.CerveLine
import com.cerve.development.ui.canvas.operators.CerveCanvas
import com.cerve.development.ui.canvas.operators.canvasSizeChange
import com.cerve.development.ui.canvas.operators.changeOrientation
import com.cerve.development.ui.canvas.operators.drawCenteredGrid
import com.cerve.development.ui.canvas.operators.drawGridBehind

@Composable
fun CerveDrawCanvas(
    gridSpacing: Float,
    strokeWidth: Dp,
    currentLines: MutableList<CerveLine>,
    currentLineCandidates: MutableList<CerveLine>,
    eraserRadius: Float,
    eraserCenter: MutableState<Offset?>,
    interactionType: CerveCanvasInteractionType?,
    modifier: Modifier = Modifier,
    eraserColor: Color = Color.Gray.copy(0.4f),
    lineColor: Color = Color.Black,
    candidateLineColor: Color = Color.LightGray,
    gridLineColor: Color = Color.Gray,
    showGridLine: Boolean = true,
    transformationScale: State<Float>,
    transformationRotation: State<Float>,
    translationOffset: State<Offset>,
    onChangeTransformationScale: (Float?) -> Unit,
    onChangeTransformationRotation: (Float?) -> Unit,
    onChangeTransformationOffset: (Offset?) -> Unit
) {

    CerveCanvas(
        modifier = modifier
            .drawGridBehind(
                color = gridLineColor,
                gridSpacing = gridSpacing,
                showGridLine = showGridLine
            ),
        gridSpacing = gridSpacing,
        interactionType = interactionType,
        strokeWidth = strokeWidth,
        currentLines = currentLines,
        currentLineCandidates = currentLineCandidates,
        eraserRadius = eraserRadius,
        eraserCenter = eraserCenter,
        eraserColor = eraserColor,
        lineColor = lineColor,
        candidateLineColor = candidateLineColor,
        transformationScale = transformationScale,
        transformationRotation = transformationRotation,
        translationOffset = translationOffset,
        onChangeTransformationScale = onChangeTransformationScale,
        onChangeTransformationRotation = onChangeTransformationRotation,
        onChangeTransformationOffset = onChangeTransformationOffset
    )
}

@Composable
fun CerveDrawMapCanvas(
    strokeWidth: Dp,
    currentLines: MutableList<CerveLine>,
    currentLineCandidates: MutableList<CerveLine>,
    eraserRadius: Float,
    eraserCenter: MutableState<Offset?>,
    interactionType: CerveCanvasInteractionType?,
    modifier: Modifier = Modifier,
    eraserColor: Color = Color.Gray.copy(0.4f),
    lineColor: Color = Color.Black,
    candidateLineColor: Color = Color.LightGray,
    gridLineColor: Color = Color.Gray,
    showGridLine: Boolean = true,
    transformationScale: State<Float>,
    transformationRotation: State<Float>,
    translationOffset: State<Offset>,
    onChangeTransformationScale: (Float?) -> Unit,
    onChangeTransformationRotation: (Float?) -> Unit,
    onChangeTransformationOffset: (Offset?) -> Unit
) {

    var canvasSize = remember { mutableStateOf(CerveCanvasSize(Size.Zero)) }

    CerveCanvas(
        modifier = modifier
            .changeOrientation(
                scale = transformationScale.value,
                rotation = transformationRotation.value,
                offset = translationOffset.value
            )
            .canvasSizeChange(canvasSize)
            .drawCenteredGrid(
                color = gridLineColor,
                size = canvasSize.value.grid.size,
                spacing = canvasSize.value.grid.spacing,
                count = canvasSize.value.grid.lineCount,
                offset = canvasSize.value.grid.drawSpaceOffset,
                showGridLine = showGridLine
            ),
        gridSpacing = canvasSize.value.grid.spacing,
        interactionType = interactionType,
        strokeWidth = strokeWidth,
        currentLines = currentLines,
        currentLineCandidates = currentLineCandidates,
        eraserRadius = eraserRadius,
        eraserCenter = eraserCenter,
        eraserColor = eraserColor,
        lineColor = lineColor,
        candidateLineColor = candidateLineColor,
        transformationScale = transformationScale,
        transformationRotation = transformationRotation,
        translationOffset = translationOffset,
        onChangeTransformationScale = onChangeTransformationScale,
        onChangeTransformationRotation = onChangeTransformationRotation,
        onChangeTransformationOffset = onChangeTransformationOffset
    )
}