package com.cerve.development.ui.canvas.model

import androidx.compose.ui.geometry.Offset
import androidx.compose.ui.geometry.Size
import com.cerve.development.ui.canvas.operators.roundToNearest

data class CerveCanvasSize(
    val size: Size,
    val center: Size = size.div(2f).roundToNearest(),
) {

    val grid: CerveCanvasGrid by lazy {

        val gridSize = size.minDimension.roundToNearest(1000)
        val gridCenter = gridSize.div(2)
        val gridSpacing = gridSize.div(100f)
        val gridLineCount = gridSize.div(gridSpacing).toInt()

        val gridCenterOffset = Offset(x = gridCenter, y = gridCenter)
        val gridDrawOffset = Offset(x = center.width, y = center.height) - gridCenterOffset

        CerveCanvasGrid(
            size = gridSize,
            center = gridCenter,
            centerOffset = gridCenterOffset,
            spacing = gridSpacing,
            lineCount = gridLineCount,
            drawSpaceOffset = gridDrawOffset
        )
    }
}
