package com.cerve.development.ui.canvas.model

import androidx.compose.runtime.MutableState
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableFloatStateOf
import androidx.compose.runtime.mutableStateListOf
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.setValue
import androidx.compose.runtime.snapshots.SnapshotStateList
import androidx.compose.ui.geometry.Offset

data class CerveDrawCanvasState(
    internal val initialLines: List<CerveLine> = emptyList(),
    private val initialOffset: Offset = Offset.Zero,
    internal val initialScale: Float = 1f,
    private val initialRotation: Float = 0f,
    val historyLines: SnapshotStateList<CerveLine> = mutableStateListOf<CerveLine>(),
    val eraserRadius: Float = 100f,
    val eraserCenter: MutableState<Offset?> = mutableStateOf<Offset?>(null),
    val currentLines: SnapshotStateList<CerveLine> = mutableStateListOf<CerveLine>(),
    val currentLineCandidates: SnapshotStateList<CerveLine> = mutableStateListOf<CerveLine>()
) {

    var interactionType by mutableStateOf<CerveCanvasInteractionType?>(null)
        private set

    var transformationOffset = mutableStateOf(initialOffset)
        private set

    var transformationScale = mutableFloatStateOf(initialScale)
        private set

    var transformationRotation = mutableStateOf(initialRotation)
        private set

    init { currentLines.addAll(initialLines) }

    fun onChangeInteractionType(
        type: CerveCanvasInteractionType
    ) { interactionType = type }

    fun onChangeTransformationScale(
        scale: Float?
    ) { transformationScale.value = scale ?: initialScale }

    fun onChangeTransformationRotation(
        rotation: Float?
    ) { transformationRotation.value = rotation ?: initialRotation }

    fun onChangeTransformationOffset(
        offset: Offset?
    ) { transformationOffset.value = offset ?: initialOffset }

    fun onUndo() {
        val removed = currentLines.removeLastOrNull()
        removed?.let { historyLines.add(removed) }
    }

    fun onRedo() {
        val history = historyLines.removeLastOrNull()
        history?.let { currentLines.add(history) }
    }

    fun onClear() {
        historyLines.clear()
        eraserCenter.value = null
        currentLines.clear()
        currentLineCandidates.clear()
    }

    fun onResetAllTransformation() {
        transformationRotation.value = 0f
        transformationScale.value = 1f
        transformationOffset.value = Offset.Zero
    }

}