package com.cerve.development.ui.canvas.model

import kotlinx.serialization.Serializable

@Serializable
data class CerveLine(
    val start: CerveOffset,
    val end: CerveOffset
) {

    companion object {
        fun defaultCerveLine(
            start: CerveOffset,
            end: CerveOffset
        ) = CerveLine(
            start = start,
            end = end
        )

        fun CerveOffset.toCerveLine() = CerveLine(
            start = this, end = this
        )
    }
}
