package com.cerve.development.ui.canvas.model

import androidx.compose.ui.geometry.Offset
import kotlinx.serialization.Serializable

@Serializable
data class CerveOffset(
    val x: Double,
    val y: Double
) {
    fun toStandardOffset() : Offset = Offset(x = x.toFloat(), y = y.toFloat())

    companion object {
        val ZERO = CerveOffset(0.0, 0.0)
        fun Offset.toCerveOffset() = CerveOffset(
            x = x.toDouble(),
            y = y.toDouble()
        )

    }
}
