package com.cerve.development.ui.canvas.operators

import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.drawWithCache
import androidx.compose.ui.geometry.Offset
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.drawscope.translate
import androidx.compose.ui.graphics.graphicsLayer

fun Modifier.drawGridBehind(
    color: Color,
    gridSpacing: Float,
    showGridLine: Boolean = true
) : Modifier = if (showGridLine) {
    drawWithCache {
        onDrawBehind {
            val width = size.width
            val height = size.height

            // Draw vertical lines
            for (x in 0..((width / gridSpacing).toInt())) {
                drawLine(
                    start = Offset(x = x * gridSpacing, y = 0f),
                    end = Offset(x = x * gridSpacing, y = height),
                    color = color
                )

            }

            // Draw horizontal lines
            for (y in 0..((height / gridSpacing).toInt())) {
                drawLine(
                    start = Offset(x = 0f, y = y * gridSpacing),
                    end = Offset(x = width, y = y * gridSpacing),
                    color = color
                )
            }
        }
    }
} else this

fun Modifier.drawCenteredGrid(
    color: Color,
    size: Float,
    spacing: Float,
    count: Int,
    offset: Offset,
    showGridLine: Boolean = true
) : Modifier = if (showGridLine) {
    drawWithCache {
        onDrawBehind {
            translate(left = offset.x, top = offset.y) {
                // Draw vertical lines
                for (x in 0..count) {
                    drawLine(
                        start = Offset(x = x * spacing, y = 0f),
                        end = Offset(x = x * spacing, y = size),
                        color = color
                    )

                }

                // Draw horizontal lines
                for (y in 0..count) {
                    drawLine(
                        start = Offset(x = 0f, y = y * spacing),
                        end = Offset(x = size, y = y * spacing),
                        color = color
                    )
                }
            }
        }

    }
} else this

fun Modifier.changeOrientation(
    scale: Float,
    rotation: Float,
    offset: Offset
) : Modifier = graphicsLayer {
    scaleX = scale
    scaleY = scale
    rotationZ = rotation
    translationX = offset.x
    translationY = offset.y
}

