package com.cerve.development.ui.canvas.operators

import androidx.compose.foundation.Canvas
import androidx.compose.runtime.Composable
import androidx.compose.runtime.MutableState
import androidx.compose.runtime.State
import androidx.compose.ui.Modifier
import androidx.compose.ui.geometry.Offset
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.unit.Dp
import com.cerve.development.ui.canvas.model.CerveCanvasInteractionType
import com.cerve.development.ui.canvas.model.CerveLine

@Composable
fun CerveCanvas(
    strokeWidth: Dp,
    gridSpacing: Float,
    currentLines: MutableList<CerveLine>,
    currentLineCandidates: MutableList<CerveLine>,
    eraserRadius: Float,
    eraserCenter: MutableState<Offset?>,
    interactionType: CerveCanvasInteractionType?,
    modifier: Modifier = Modifier,
    eraserColor: Color = Color.Gray.copy(0.4f),
    lineColor: Color = Color.Black,
    candidateLineColor: Color = Color.LightGray,
    transformationScale: State<Float>,
    transformationRotation: State<Float>,
    translationOffset: State<Offset>,
    onChangeTransformationScale: (Float?) -> Unit,
    onChangeTransformationRotation: (Float?) -> Unit,
    onChangeTransformationOffset: (Offset?) -> Unit
) {

    Canvas(
        modifier = modifier
           .canvasInput(
                key = interactionType,
                gridSpacing = gridSpacing,
                eraserCenter = eraserCenter,
                eraserRadius = eraserRadius,
                currentLines = currentLines,
                currentLineCandidates = currentLineCandidates,
                transformationScale = transformationScale,
                transformationRotation = transformationRotation,
                translationOffset = translationOffset,
                onChangeTransformationScale = onChangeTransformationScale,
                onChangeTransformationRotation = onChangeTransformationRotation,
                onChangeTransformationOffset = onChangeTransformationOffset
            )
    ) {
        canvasScope(
            strokeWidth = strokeWidth,
            eraserColor = eraserColor,
            eraserRadius = eraserRadius,
            eraserCenter = eraserCenter,
            lineColor = lineColor,
            currentLines = currentLines,
            candidateLineColor = candidateLineColor,
            currentLineCandidates = currentLineCandidates
        )
    }

}