package com.cerve.development.ui.canvas.operators

import androidx.compose.runtime.MutableState
import androidx.compose.ui.geometry.Offset
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.StrokeCap
import androidx.compose.ui.graphics.drawscope.DrawScope
import androidx.compose.ui.graphics.drawscope.Fill
import androidx.compose.ui.unit.Dp
import com.cerve.development.ui.canvas.model.CerveLine

fun DrawScope.canvasScope(
    strokeWidth: Dp,
    eraserColor: Color,
    eraserRadius: Float,
    eraserCenter: MutableState<Offset?>,
    lineColor: Color,
    currentLines: MutableList<CerveLine>,
    candidateLineColor: Color,
    currentLineCandidates: MutableList<CerveLine>
) {
    currentLineCandidates.forEach { line ->
        drawLine(
            color = candidateLineColor,
            start = line.start.toStandardOffset(),
            end = line.end.toStandardOffset(),
            strokeWidth = strokeWidth.toPx(),
            cap = StrokeCap.Round
        )
    }

    currentLines.forEach { line ->
        drawLine(
            color = lineColor,
            start = line.start.toStandardOffset(),
            end = line.end.toStandardOffset(),
            strokeWidth = strokeWidth.toPx(),
            cap = StrokeCap.Round
        )
    }

    eraserCenter.value?.let { eraserCenter ->
        drawCircle(
            color = eraserColor,
            center = eraserCenter,
            radius = eraserRadius,
            style = Fill
        )
    }
}