package com.cerve.development.ui.canvas.operators

import androidx.compose.ui.geometry.Offset

fun orientationOffset(p: Offset, q: Offset, r: Offset): Int {
    val value = (q.y - p.y) * (r.x - q.x) - (q.x - p.x) * (r.y - q.y)
    return when {
        value == 0f -> 0 // Collinear
        value > 0f -> 1 // Clockwise
        else -> 2 // Counterclockwise
    }
}

fun onSegmentOffset(p: Offset, q: Offset, r: Offset): Boolean {
    return q.x <= maxOf(p.x, r.x) && q.x >= minOf(p.x, r.x) &&
            q.y <= maxOf(p.y, r.y) && q.y >= minOf(p.y, r.y)
}
