package com.cerve.development.ui.canvas.operators

import com.cerve.development.ui.canvas.model.CerveLine

fun updateLinesOnPlane(allLines: MutableList<CerveLine>, newLine: CerveLine) {
    val newLineLength = calculateLineLength(newLine)
    val plane = determinePlane(newLine)

    val existingLineIndex = allLines.indexOfFirst {
        determinePlane(it) == plane &&
                (it.start == newLine.start && it.end == newLine.end ||
                        it.start == newLine.end && it.end == newLine.start)
    }

    if (existingLineIndex != -1) {
        val existingLineLength = calculateLineLength(allLines[existingLineIndex])
        if (newLineLength > existingLineLength) {
            allLines[existingLineIndex] = newLine
        }
    } else {
        allLines.add(newLine)
    }
}

private fun determinePlane(line: CerveLine): Pair<Float, Float> {
    return if (line.start.x == line.end.x) {
        Pair(line.start.x.toFloat(), Float.NaN)
    } else if (line.start.y == line.end.y) {
        Pair(Float.NaN, line.start.y.toFloat())
    } else {
        Pair(Float.NaN, Float.NaN)
    }
}