package com.cerve.development.ui.canvas.operators

import androidx.compose.foundation.gestures.detectTapGestures
import androidx.compose.runtime.MutableState
import androidx.compose.runtime.State
import androidx.compose.ui.Modifier
import androidx.compose.ui.geometry.Offset
import androidx.compose.ui.input.pointer.pointerInput
import com.cerve.development.ui.canvas.model.CerveCanvasInteractionType
import com.cerve.development.ui.canvas.model.CerveLine

fun Modifier.canvasInput(
    key: CerveCanvasInteractionType?,
    gridSpacing: Float,
    eraserRadius: Float,
    eraserCenter: MutableState<Offset?>,
    currentLines: MutableList<CerveLine>,
    currentLineCandidates: MutableList<CerveLine>,
    transformationScale: State<Float>,
    transformationRotation: State<Float>,
    translationOffset: State<Offset>,
    onChangeTransformationScale: (Float?) -> Unit,
    onChangeTransformationRotation: (Float?) -> Unit,
    onChangeTransformationOffset: (Offset?) -> Unit
) = pointerInput(key) {
    when(key) {
        null -> Unit
        CerveCanvasInteractionType.Zoom -> {
            zoomGestures(
                transformationScale = transformationScale,
                transformationRotation = transformationRotation,
                translationOffset = translationOffset,
                onChangeTransformationScale = onChangeTransformationScale,
                onChangeTransformationRotation = onChangeTransformationRotation,
                onChangeTransformationOffset = onChangeTransformationOffset
            )
        }
        CerveCanvasInteractionType.Brush -> {
            brushGestures(currentLines = currentLines)
        }
        CerveCanvasInteractionType.AssistedBrush -> {
            assistedBrushGestures(
                gridSpacing = gridSpacing,
                currentLines = currentLines,
                currentLineCandidates = currentLineCandidates
            )
        }
        CerveCanvasInteractionType.SegmentedBrush -> {
            segmentedBrushGestures(
                gridSpacing = gridSpacing,
                currentLines = currentLines,
                currentLineCandidates = currentLineCandidates
            )
        }
        CerveCanvasInteractionType.Eraser -> {
            eraserGestures(
                eraserCenter = eraserCenter,
                eraserRadius = eraserRadius,
                currentLines = currentLines
            )
        }
    }
}.pointerInput(key == CerveCanvasInteractionType.Zoom) {
    if (key == CerveCanvasInteractionType.Zoom) {
        detectTapGestures(
            onDoubleTap = {
                onChangeTransformationScale(null)
                onChangeTransformationRotation(null)
                onChangeTransformationOffset(null)
            }
        )
    }
}