package com.cerve.development.ui.canvas.operators

import androidx.compose.ui.geometry.Offset
import androidx.compose.ui.geometry.Size
import com.cerve.development.ui.canvas.model.CerveLine
import com.cerve.development.ui.canvas.model.CerveOffset
import kotlin.math.round
import kotlin.math.roundToInt

fun CerveOffset.roundToNearest(bound: Float): CerveOffset {
    val x = ((x / bound).roundToInt() * bound).toDouble()
    val y = ((y / bound).roundToInt() * bound).toDouble()
    return copy(x = x, y = y)
}

fun CerveLine.roundToNearest(bound: Float): CerveLine {
    val start = start.roundToNearest(bound)
    val end = end.roundToNearest(bound)
    return copy(start = start, end = end)
}

fun Float.roundToNearest(
    nearest: Int = 10,
): Float = round(this / nearest) * nearest

fun Size.roundToNearest(
    nearest: Int = 10
): Size = copy(width.roundToNearest(nearest), height = height.roundToNearest(nearest))

fun snapToGrid(offset: Offset, spacing: Float): Offset {
    val snappedX = (offset.x / spacing).roundToInt() * spacing
    val snappedY = (offset.y / spacing).roundToInt() * spacing
    return Offset(snappedX, snappedY)
}
fun Offset.snapToGrid(spacing: Float): CerveOffset {
    val snappedX = ((x / spacing).roundToInt() * spacing).toDouble()
    val snappedY = ((y / spacing).roundToInt() * spacing).toDouble()
    return CerveOffset(snappedX, snappedY)
}
fun CerveOffset.snapToGrid(spacing: Float): CerveOffset {
    val snappedX = ((x / spacing).roundToInt() * spacing).toDouble()
    val snappedY = ((y / spacing).roundToInt() * spacing).toDouble()
    return copy(snappedX, snappedY)
}
fun CerveLine.snapToGrid(spacing: Float): CerveLine {
    return CerveLine(
        start = start.snapToGrid(spacing),
        end = end.snapToGrid(spacing)
    )
}